﻿<%@ Page Language="C#" MasterPageFile="~/inner.Master" AutoEventWireup="true" CodeBehind="default.aspx.cs" ValidateRequest="false" Inherits="SedonaWeb.service_tickets._default" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cphHead" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cphContent" runat="server">

  <asp:Panel ID="OpenPanel" runat="server">
    <p class="TableCellAlignCenter LargeLabel">Open Tickets</p>
    <telerik:RadGrid ID="RadGridOpenServiceTickets" AllowSorting="true" AutoGenerateColumns="false"
      runat="server" AllowPaging="True" DataSourceID="SqlDataSource1" OnItemDataBound="RadGridOnItemBound">
      <MasterTableView DataKeyNames="Ticket_Id">
        <Columns>
          <telerik:GridTemplateColumn UniqueName="TicketNumber" DataField="InvoiceNumber" SortExpression="TicketNumber"
            HeaderText="Ticket #">
            <ItemTemplate>
              <asp:HyperLink ID='HyperLinkInvoiceDetail' NavigateUrl='<%# "./service.aspx?ticket=" + Uri.EscapeDataString(DataBinder.Eval(Container.DataItem, "TicketNumber").ToString()) %>'
                runat='server' Text='<%# DataBinder.Eval(Container.DataItem, "TicketNumber") %>'
                Visible='true' ToolTip='<%# DataBinder.Eval(Container.DataItem, "LastNoteText") %>' />
            </ItemTemplate>
          </telerik:GridTemplateColumn>
          <telerik:GridTemplateColumn UniqueName="SiteName" DataField="SiteName" HeaderText="Site"
            SortExpression="SiteName">
            <ItemTemplate>
              <asp:Label ID="lblSiteName" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "SiteName") %>'
                ToolTip='<%# DataBinder.Eval(Container.DataItem, "LastNoteText") %>' />
            </ItemTemplate>
          </telerik:GridTemplateColumn>
          <telerik:GridTemplateColumn UniqueName="AlarmAccount" DataField="AlarmAccount" HeaderText="Account #"
            SortExpression="AlarmAccount">
            <ItemTemplate>
              <asp:Label ID="lblAlarmAccount" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "AlarmAccount") %>'
                ToolTip='<%# DataBinder.Eval(Container.DataItem, "LastNoteText") %>' />
            </ItemTemplate>
          </telerik:GridTemplateColumn>
          <telerik:GridTemplateColumn UniqueName="SystemCode" DataField="SystemCode" HeaderText="System"
            SortExpression="SystemCode">
            <ItemTemplate>
              <asp:Label ID="lblSystemCode" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "SystemCode") %>'
                ToolTip='<%# DataBinder.Eval(Container.DataItem, "LastNoteText") %>' />
            </ItemTemplate>
          </telerik:GridTemplateColumn>
          <telerik:GridTemplateColumn UniqueName="CreatedOn" DataField="CreatedOn" HeaderText="Created"
            SortExpression="CreatedOn">
            <ItemTemplate>
              <asp:Label ID="lblCreatedOn" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "CreatedOn","{0:d}") %>'
                ToolTip='<%# DataBinder.Eval(Container.DataItem, "LastNoteText") %>' />
            </ItemTemplate>
          </telerik:GridTemplateColumn>
          <telerik:GridTemplateColumn UniqueName="ProblemCode" DataField="ProblemCode" HeaderText="Problem"
            SortExpression="ProblemCode">
            <ItemTemplate>
              <asp:Label ID="lblProblemCode" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "ProblemCode") %>'
                ToolTip='<%# DataBinder.Eval(Container.DataItem, "LastNoteText") %>' />
            </ItemTemplate>
          </telerik:GridTemplateColumn>
          <telerik:GridTemplateColumn SortExpression="TicketStatus" DataField="TicketStatus"
            HeaderText="Status">
            <ItemTemplate>
              <asp:Label ID="lblTicketStatus" runat="server" Text='<%# TicketStatusText(DataBinder.Eval(Container.DataItem, "TicketStatus").ToString()) %>'
                ToolTip='<%# DataBinder.Eval(Container.DataItem, "ScheduledTime","{0:d t}")+ " " +  DataBinder.Eval(Container.DataItem, "EmpFullName")%>' />
              <%--<%#TicketStatusText(DataBinder.Eval(Container.DataItem,"TicketStatus").ToString()) %>--%>
            </ItemTemplate>
          </telerik:GridTemplateColumn>
          <telerik:GridTemplateColumn UniqueName="LastNote" DataField="LastNote" HeaderText="Last Note"
            SortExpression="LastNote">
            <ItemTemplate>
              <asp:Label ID="lblLastNote" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "LastNote","{0:d}") %>'
                ToolTip='<%# DataBinder.Eval(Container.DataItem, "LastNoteText") %>' />
            </ItemTemplate>
          </telerik:GridTemplateColumn>
          <telerik:GridTemplateColumn UniqueName="DocumentCount" SortExpression="DocumentCount"
            HeaderText="Docs">
            <ItemTemplate>
              <asp:Label ID="lblDocumentCount" runat="server" Text="" />
            </ItemTemplate>
          </telerik:GridTemplateColumn>
        </Columns>
      </MasterTableView>
    </telerik:RadGrid>
  </asp:Panel>

  <asp:Panel ID="ClosedPanel" Visible="False" runat="server">
    <p class="TableCellAlignCenter LargeLabel">Closed Tickets</p>
    <telerik:RadGrid ID="RadGridClosedServiceTickets" AllowSorting="true" AutoGenerateColumns="false"
      runat="server" AllowPaging="true" DataSourceID="SqlDataSource1">
      <MasterTableView>
        <Columns>
          <telerik:GridTemplateColumn UniqueName="TicketNumber" DataField="TicketNumber" SortExpression="TicketNumber"
            HeaderText="Ticket #">
            <ItemTemplate>
              <asp:HyperLink ID='HyperLinkInvoiceDetail' NavigateUrl='<%# "./service.aspx?ticket=" + Uri.EscapeDataString(DataBinder.Eval(Container.DataItem, "TicketNumber").ToString()) %>'
                runat='server' Text='<%# DataBinder.Eval(Container.DataItem, "TicketNumber") %>' />
            </ItemTemplate>
          </telerik:GridTemplateColumn>
          <telerik:GridBoundColumn AllowSorting="true" DataField="SiteName" HeaderText="Site" />
          <telerik:GridBoundColumn AllowSorting="true" DataField="AlarmAccount" HeaderText="Account #" />
          <telerik:GridBoundColumn AllowSorting="true" DataField="SystemCode" HeaderText="System" />
          <telerik:GridBoundColumn AllowSorting="true" DataField="ClosedDate" DataType="System.DateTime"
            HeaderText="Closed" DataFormatString="{0:d}" />
          <telerik:GridBoundColumn AllowSorting="true" DataField="ProblemCode" HeaderText="Problem" />
          <telerik:GridBoundColumn AllowSorting="true" DataField="ResolutionCode" HeaderText="Resolution" />
        </Columns>
      </MasterTableView>
    </telerik:RadGrid>
  </asp:Panel>

  <asp:Panel ID="QueuePanel" Visible="False" runat="server">
    <p class="TableCellAlignCenter LargeLabel">Ticket Queue</p>
    <telerik:RadGrid ID="RadGridServiceTicketQue" runat="server"
      AutoGenerateColumns="false" AllowSorting="true" AllowPaging="true" DataSourceID="SqlDataSource1">
      <MasterTableView>
        <Columns>
          <telerik:GridTemplateColumn UniqueName="TicketNumber" DataField="TicketNumber" SortExpression="TicketNumber"
            HeaderText="Ticket #">
            <ItemTemplate>
              <asp:HyperLink ID='HyperLinkInvoiceDetail' NavigateUrl='<%# "./service.aspx?ticket=" + Uri.EscapeDataString(DataBinder.Eval(Container.DataItem, "TicketNumber").ToString()) %>'
                runat='server' Text='<%# DataBinder.Eval(Container.DataItem, "TicketNumber") %>'
                Visible='true' />
            </ItemTemplate>
          </telerik:GridTemplateColumn>
          <telerik:GridBoundColumn AllowSorting="true" DataField="SiteName" HeaderText="Site" />
          <telerik:GridBoundColumn AllowSorting="true" DataField="AlarmAccount" HeaderText="Account #" />
          <telerik:GridBoundColumn AllowSorting="true" DataField="SiteCity" HeaderText="City" />
          <telerik:GridBoundColumn AllowSorting="true" DataField="SiteAddress" HeaderText="Address" />
          <telerik:GridBoundColumn AllowSorting="true" DataField="CreatedOn" DataType="System.DateTime"
            HeaderText="Created" DataFormatString="{0:d}" />
          <telerik:GridBoundColumn AllowSorting="true" DataField="ProblemCode" HeaderText="Problem" />
          <telerik:GridTemplateColumn UniqueName="Scheduled" DataField="ScheduledFor" SortExpression="ScheduledFor"
            HeaderText="Scheduled">
            <ItemTemplate>
              <asp:Label ID="lblScheduled" runat="server" Text='<%# DateTime.Parse(DataBinder.Eval(Container.DataItem, "ScheduledFor").ToString())>DateTime.Parse("1899-12-30")?DateTime.Parse(DataBinder.Eval(Container.DataItem, "ScheduledFor").ToString()).ToString("g"):"" %>' />
            </ItemTemplate>
          </telerik:GridTemplateColumn>
        </Columns>
      </MasterTableView>
    </telerik:RadGrid>
  </asp:Panel>

  <asp:SqlDataSource ID="SqlDataSource1" runat="server"></asp:SqlDataSource>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="cphScripts" runat="server">
</asp:Content>
