﻿<%@ Page Language="C#" MasterPageFile="~/inner.Master" AutoEventWireup="true"
    CodeBehind="create.aspx.cs" Inherits="SedonaWeb.service_tickets._create" ValidateRequest="false" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cphHead" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cphContent" runat="server">
    <script type="text/javascript">
        function CharsLeft(txtData, txtLen, maxNum, prefix) {
            if (txtData.value.length > maxNum) {
                txtData.value = txtData.value.substring(0, maxNum);
            }
            txtLen.value = prefix + ' ' + (maxNum - txtData.value.length).toString();
        }
    </script>
    <asp:UpdatePanel ID="upPnl" UpdateMode="Always" runat="server">
        <Triggers>
            <asp:PostBackTrigger ControlID="btnSubmit" />
        </Triggers>
        <ContentTemplate>
            <asp:Label ID="lblMsg" runat="server" CssClass="error_message" />
            <asp:Table CssClass="TableType1" ID="CreateNewTicketTable" runat="server" Visible="true">
                <asp:TableRow>
                    <asp:TableCell Width="20%" CssClass="TableCellAlignLeft">
                        <asp:Label ID="Label1" CssClass="MediumLabel" runat="server" Text="Site and System:" />
                    </asp:TableCell><asp:TableCell>
                        <asp:DropDownList CssClass="DropDownList" ID="ddlSiteList" AutoPostBack="true" OnSelectedIndexChanged="PopulateSystemDropDownList_OnIndexChanged"
                            runat="server" />
                        <asp:DropDownList CssClass="DropDownList" ID="ddlSystemList" runat="server" />
                        <asp:CompareValidator runat="server" ID="cpvSiteList" ControlToValidate="ddlSiteList"
                            CssClass="error_message_small" Display="Dynamic" ErrorMessage="Please select a Site from the list"
                            ValueToCompare="--Select Site--" Operator="NotEqual" />
                        <asp:CompareValidator runat="server" ID="cpvSystemList" ControlToValidate="ddlSystemList"
                            CssClass="error_message_small" Display="Dynamic" ErrorMessage="Please select a System for the Site"
                            ValueToCompare="--Select System--" Operator="NotEqual" />
                    </asp:TableCell></asp:TableRow>
                <asp:TableRow>
                    <asp:TableCell CssClass="TableCellAlignLeft">
                        <asp:Label ID="Label2" CssClass="MediumLabel" runat="server" Text="Requested By:" />
                    </asp:TableCell><asp:TableCell>
                        <asp:TextBox CssClass="LargeTextBox" ID="txtRequestedBy" MaxLength="200" runat="server" />
                    </asp:TableCell></asp:TableRow>
                <asp:TableRow>
                    <asp:TableCell CssClass="TableCellAlignLeft">
                        <asp:Label ID="Label3" CssClass="MediumLabel" runat="server" Text="Phone Number:" />
                    </asp:TableCell><asp:TableCell>
                        <asp:TextBox CssClass="MediumTextBox" ID="txtPhoneNumber" MaxLength="14" runat="server" />
                        <asp:RegularExpressionValidator ID="RegularExpressionValidator1" ControlToValidate="txtPhoneNumber"
                            CssClass="error_message_small" ErrorMessage="Invalid Phone Number" Display="Dynamic"
                            runat="server" ValidationExpression="^(\([2-9]\d{2}|[2-9]\d{2})[\)\- .]\d{3}[\- .]\d{4}$" />
                    </asp:TableCell></asp:TableRow>
                <asp:TableRow>
                    <asp:TableCell CssClass="TableCellAlignLeft">
                        <asp:Label ID="Label5" CssClass="MediumLabel" runat="server" Text="Problem:" />
                    </asp:TableCell><asp:TableCell>
                        <asp:DropDownList CssClass="DropDownList" ID="ddlProblemDropDownList" runat="server" />
                        <asp:CompareValidator ID="ProblemDropDownList_Compare" ControlToValidate="ddlProblemDropDownList"
                            Display="Dynamic" ErrorMessage="Please select a Problem code from the list" Operator="NotEqual"
                            runat="server" ValueToCompare="--Problem Code--" CssClass="error_message_small" />
                    </asp:TableCell></asp:TableRow>
                <asp:TableRow>
                    <asp:TableCell CssClass="TableCellAlignLeft">
                        <asp:Label ID="Label6" CssClass="MediumLabel" runat="server" Text="Priority:" />
                    </asp:TableCell><asp:TableCell>
                        <asp:DropDownList CssClass="DropDownList" ID="ddlPriorityDropDownList" runat="server">
                            <asp:ListItem Value="Low" Text="Low" />
                            <asp:ListItem Value="Medium" Text="Medium" />
                            <asp:ListItem Value="High" Text="High" />
                            <asp:ListItem Value="Critical" Text="Critical" />
                        </asp:DropDownList>
                    </asp:TableCell></asp:TableRow>
                <asp:TableRow>
                    <asp:TableCell CssClass="TableCellAlignLeft">
                        <asp:Label ID="lblComments" CssClass="MediumLabel" Text="Comments:" runat="server" />
                        <input readonly="readonly" type="text" name="txtCommentsLen" style="border: none" />
                    </asp:TableCell><asp:TableCell>
                        <asp:TextBox Columns="90" CssClass="TextArea" ID="txtComments" Rows="3" runat="server"
                            TextMode="MultiLine" 
                            onchange="CharsLeft(this, this.form.txtCommentsLen, 250, 'Chars left - '); "
                            onkeydown="CharsLeft(this, this.form.txtCommentsLen, 250, 'Chars left - '); "
                            onkeyup="CharsLeft(this, this.form.txtCommentsLen, 250, 'Chars left - '); " />
                        <asp:RequiredFieldValidator ID="rfvComments" ControlToValidate="txtComments" CssClass="error_message_small"
                            Display="Dynamic" ErrorMessage="* Required" runat="server" />
                        <br />
                    </asp:TableCell></asp:TableRow>
                <asp:TableRow>
                    <asp:TableCell CssClass="TableCellAlignLeft">
                        <asp:Label ID="lblNote1" CssClass="MediumLabel" Text="Note 1:" runat="server" />
                        <input readonly="readonly" type="text" name="txtNote1Len" style="border: none" />
                    </asp:TableCell><asp:TableCell>
                        <asp:TextBox Columns="90" CssClass="TextArea" ID="txtNote1" Rows="9" runat="server" 
                            TextMode="MultiLine"
                            onchange="CharsLeft(this, this.form.txtNote1Len, 1024, 'Chars left - '); "
                            onkeydown="CharsLeft(this, this.form.txtNote1Len, 1024, 'Chars left - '); "
                            onkeyup="CharsLeft(this, this.form.txtNote1Len, 1024, 'Chars left - '); " />
                        <br />
                    </asp:TableCell></asp:TableRow>
                <asp:TableRow>
                    <asp:TableCell CssClass="TableCellAlignLeft">
                        <asp:Label ID="lblNote2" CssClass="MediumLabel" Text="Note 2:" runat="server" />
                        <input readonly="readonly" type="text" name="txtNote2Len" style="border: none" />
                    </asp:TableCell><asp:TableCell>
                        <asp:TextBox Columns="90" CssClass="TextArea" ID="txtNote2" Rows="9" runat="server"
                            TextMode="MultiLine"
                            onchange="CharsLeft(this, this.form.txtNote2Len, 1024, 'Chars left - '); "
                            onkeydown="CharsLeft(this, this.form.txtNote2Len, 1024, 'Chars left - '); "
                            onkeyup="CharsLeft(this, this.form.txtNote2Len, 1024, 'Chars left - '); " />
                        <br />
                    </asp:TableCell></asp:TableRow>
                <asp:TableRow>
                    <asp:TableCell CssClass="TableCellAlignLeft">
                        <asp:Label ID="lblNote3" CssClass="MediumLabel" Text="Note 3:" runat="server" />
                        <input readonly="readonly" type="text" name="txtNote3Len" style="border: none" />
                    </asp:TableCell><asp:TableCell>
                        <asp:TextBox Columns="90" CssClass="TextArea" ID="txtNote3" Rows="9" runat="server"
                            TextMode="MultiLine"
                            onchange="CharsLeft(this, this.form.txtNote3Len, 1024, 'Chars left - '); "
                            onkeydown="CharsLeft(this, this.form.txtNote3Len, 1024, 'Chars left - '); "
                            onkeyup="CharsLeft(this, this.form.txtNote3Len, 1024, 'Chars left - '); " />
                        <br />
                    </asp:TableCell></asp:TableRow>
                <asp:TableRow>
                    <asp:TableCell CssClass="TableCellAlignLeft">
                        <asp:Label ID="Label15" CssClass="MediumLabel" Text="Upload files:" runat="server" />
                    </asp:TableCell><asp:TableCell>
                        <asp:Label ID="Label13" Text="File 1: " runat="server" />
                        <asp:FileUpload ID="fuAttachmentFile1" runat="server" />&nbsp;&nbsp;
                        <asp:Label ID="Label8" Text="(File should not be over 1 megabyte)" runat="server" /><br />
                        <asp:Label ID="Label4" Text=" Description 1:" runat="server" />
                        <asp:TextBox ID="txtAttachmentDescription1" Columns="50" MaxLength="50" Text="Web File 1"
                            runat="server" />
                        <asp:RequiredFieldValidator ID="rfvAttachmentDescription1" ControlToValidate="txtAttachmentDescription1"
                            CssClass="error_message_small" Display="Dynamic" ErrorMessage="* Required" runat="server" /><br />
                        <asp:Label ID="Label16" Text="File 2: " runat="server" />
                        <asp:FileUpload ID="fuAttachmentFile2" runat="server" />&nbsp;&nbsp;
                        <asp:Label ID="Label10" Text="(File should not be over 1 megabyte)" runat="server" /><br />
                        <asp:Label ID="Label9" Text=" Description 2:" runat="server" />
                        <asp:TextBox ID="txtAttachmentDescription2" Columns="50" MaxLength="50" Text="Web File 2"
                            runat="server" />
                        <asp:RequiredFieldValidator ID="rfvAttachmentDescription2" ControlToValidate="txtAttachmentDescription2"
                            CssClass="error_message_small" Display="Dynamic" ErrorMessage="* Required" runat="server" /><br />
                        <asp:Label ID="Label17" Text="File 3: " runat="server" />
                        <asp:FileUpload ID="fuAttachmentFile3" runat="server" />&nbsp;&nbsp;
                        <asp:Label ID="Label12" Text="(File should not be over 1 megabyte)" runat="server" /><br />
                        <asp:Label ID="Label11" Text=" Description 3:" runat="server" />
                        <asp:TextBox ID="txtAttachmentDescription3" Columns="50" MaxLength="50" Text="Web File 3"
                            runat="server" />
                        <asp:RequiredFieldValidator ID="rfvAttachmentDescription3" ControlToValidate="txtAttachmentDescription3"
                            CssClass="error_message_small" Display="Dynamic" ErrorMessage="* Required" runat="server" /><br />
                    </asp:TableCell></asp:TableRow>
                <asp:TableRow>
                    <asp:TableCell CssClass="TableCellAlignLeft">
                        &nbsp;
                    </asp:TableCell><asp:TableCell>
                        <asp:Button CssClass="SmallButton" ID="btnSubmit" OnCommand="btnSubmit_Click" Text="Submit"
                            runat="server" UseSubmitBehavior="false" OnClientClick="if (Page_ClientValidate() == true) {this.value = 'Processing...'; this.disabled = true;}" />
                    </asp:TableCell></asp:TableRow>
            </asp:Table>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="cphScripts" runat="server">
</asp:Content>
