﻿<%@ Page Language="C#" MasterPageFile="~/inner.Master" AutoEventWireup="true"
  CodeBehind="payment.aspx.cs" Inherits="SedonaWeb.payment_methods.payment" %>

<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI, Version=2012.1.411.40, Culture=neutral, PublicKeyToken=121fae78165ba3d4" %>

<%@ Register assembly="Telerik.Web.UI" namespace="Telerik.Web.UI" tagprefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cphHead" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cphContent" runat="server">

  <div class="LargeLabel TableCellAlignCenter TableType1">Selected Invoices</div>
  <telerik:RadGrid ID="InvoicesToPayGrid" runat="server" AutoGenerateColumns="false" CssClass="payment" Visible="true">
    <MasterTableView>
      <Columns>
        <telerik:GridBoundColumn DataField="Invoice_Date" HeaderText="Date" SortExpression="Invoice_Date" UniqueName="Invoice_Date" />
        <telerik:GridBoundColumn DataField="Invoice_Number" HeaderText="Invoice Number" SortExpression="Invoice_Number" UniqueName="Invoice_Number" />
        <telerik:GridBoundColumn DataField="Invoice_Description" HeaderText="Description" SortExpression="Invoice_Description" UniqueName="Invoice_Description" />
        <telerik:GridBoundColumn DataField="Due_Date" HeaderText="Due Date" UniqueName="Due_Date" />
        <telerik:GridBoundColumn DataField="Amount" HeaderText="Amount" SortExpression="Amount" UniqueName="Amount">
          <ItemStyle HorizontalAlign="Right" />
        </telerik:GridBoundColumn>
        <telerik:GridBoundColumn DataField="Net_Due" HeaderText="Balance Due" SortExpression="Net_Due" UniqueName="Net_Due">
          <ItemStyle HorizontalAlign="Right" />
        </telerik:GridBoundColumn>
      </Columns>
    </MasterTableView>
    <ItemStyle></ItemStyle>
  </telerik:RadGrid>

  <div style="margin-top: 25px">
    <asp:UpdatePanel ID="upPnl" runat="server">
      <ContentTemplate>
        <asp:Panel ID="pnlPay" runat="server">
          <table>
            <tr>
              <td width="150">Payment Method:
              </td>
              <td>
                <table>
                  <tr>
                    <td>Credit Card
                    </td>
                    <td>Bank Accounts
                    </td>
                  </tr>
                  <tr>
                    <td>
                      <asp:ListBox ID="lbCreditCard" runat="server" ClientIDMode="Static" Rows="3" Width="100%" />
                    </td>
                    <td>
                      <asp:ListBox ID="lbBankAccount" runat="server" ClientIDMode="Static" Rows="3" Width="100%" />
                    </td>
                  </tr>
                  <tr>
                    <td>
                      <asp:HyperLink ID="hlAddNewCC" runat="server" NavigateUrl="./default.aspx?add=cc">Add New</asp:HyperLink>
                    </td>
                    <td>
                      <asp:HyperLink ID="Hyperlink1" runat="server" NavigateUrl="./default.aspx?add=b">Add New</asp:HyperLink>
                    </td>
                  </tr>
                </table>
              </td>
              <td></td>
            </tr>
            <tr>
              <td colspan="3">&nbsp;
              </td>
            </tr>
            <tr>
              <td>Amount:
              </td>
              <td colspan="2">
                <asp:TextBox ID="txtPayAmount" ClientIDMode="Static" runat="server" Enabled="false"/>
                <asp:Label runat="server" ID="lblMaxAmount" CssClass="inputDes left"/>
              </td>
            </tr>
            <tr>
              <td colspan="3">&nbsp;</td>
            </tr>
            <tr>
              <td></td>
              <td>
                <asp:Button ID="btnSubmit" runat="server" Text="Submit" OnClick="btnSubmit_Click" />
                <asp:Button ID="btnCancel" runat="server" Text="Cancel" OnClick="btnCancel_Click" />
              </td>
              <td></td>
            </tr>
            <tr>
              <td colspan="3">
                  <div ID="lblSubmitErrorMsg" runat="server" class="error_message"></div>
                  <div ID="lblExpiredCreditCardsMsg" runat="server" class="info_message"></div>
              </td>
            </tr>
          </table>
        </asp:Panel>
        <asp:Panel ID="pnlConfirm" runat="server" Visible="false">
          <asp:Label ID="lblConfirmMessage" runat="server" CssClass="success_message" Text="" />
          <asp:Label ID="lblConfirmErrorMsg" runat="server" CssClass="error_message" Text="" />
          <table id="confirm">
            <tr>
              <th>Invoice:
              </th>
              <td>
                <asp:Label ID="lblConfirmInvoice" runat="server" />
              </td>
            </tr>
            <tr>
              <th>Payment Method:
              </th>
              <td>
                <asp:Label ID="lblConfirmPayment" runat="server" />
              </td>
            </tr>
            <tr>
              <th>Account:
              </th>
              <td>
                <asp:Label ID="lblConfirmAccount" runat="server" />
              </td>
            </tr>
            <tr>
              <th>Amount:
              </th>
              <td>
                <asp:Label ID="lblConfirmAmount" runat="server" />
              </td>
            </tr>
            <tr>
              <td></td>
              <td>
                <asp:Button ID="btnConfirmSubmit" Text="Confirm" runat="server" OnClick="btnConfirmSubmit_Click" />
                <asp:Button ID="btnConfirmCancel" Text="Cancel" runat="server" OnClick="btnCancel_Click" />
                <asp:Button ID="btnConfirmGoBack" Text="Select Payment Method" runat="server" OnClick="btnConfirmGoBack_Click" Visible="false" />
              </td>
            </tr>
          </table>
        </asp:Panel>
      </ContentTemplate>
    </asp:UpdatePanel>
  </div>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="cphScripts" runat="server">
  <script type="text/javascript">
    $(function () {
      // Clear the other list-box.
      $("#lbCreditCard").change(function () {
        $("#lbBankAccount")[0].selectedIndex = -1;
      });
      
      $("#lbBankAccount").change(function () {
        $("#lbCreditCard")[0].selectedIndex = -1;
      });
      
      $("#aspnetForm").submit(function () {
        $("input[type=submit][value=Submit]").attr("disabled", "disabled");
        $("input[type=submit][value=Confirm]").attr("disabled", "disabled");
      });
    });
  </script>
</asp:Content>
