﻿<%@ Page Language="C#" MasterPageFile="~/inner.Master" AutoEventWireup="true" CodeBehind="customer_manage.aspx.cs" Inherits="SedonaWeb.home.customer_manage" %>

<%@ Import Namespace="Authentication" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cphHead" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cphContent" runat="server">

  <div id="users-div">
    <p class="LargeLabel">User Accounts</p>
    <telerik:RadGrid ID="UsersGrid" AutoGenerateColumns="false" AllowSorting="true"
      Visible="true" runat="server">
      <MasterTableView>
        <Columns>
          <telerik:GridBoundColumn AllowSorting="false" DataType="System.String" DataField="AccountName" HeaderText="Account Name" UniqueName="AccountName" />
          <telerik:GridBoundColumn AllowSorting="false" DataType="System.String" DataField="ContactName" HeaderText="Contact Name" UniqueName="ContactName" />
          <telerik:GridBoundColumn AllowSorting="false" DataType="System.String" DataField="LastLogin" HeaderText="Last Login" UniqueName="LastLogin" />
          <telerik:GridTemplateColumn HeaderText="Status">
            <ItemTemplate>
              <%# GetActiveLabel(Container.DataItem as WebAccount) %>
            </ItemTemplate>
          </telerik:GridTemplateColumn>
          <telerik:GridTemplateColumn>
            <ItemTemplate>
              <%# GetActiveLink((bool) DataBinder.Eval(Container.DataItem, "Inactive"), (int) DataBinder.Eval(Container.DataItem, "AccountId")) %>
            </ItemTemplate>
          </telerik:GridTemplateColumn>
        </Columns>
      </MasterTableView>
    </telerik:RadGrid>
  </div>

  <p class="LargeLabel">Companies</p>
  <telerik:RadGrid ID="rgCustomers" DataSourceID="sqlCustomers" AutoGenerateColumns="false" AllowSorting="true"
    OnItemCommand="rgCustomers_ItemCommand" Visible="true" runat="server">
    <MasterTableView>
      <Columns>
        <telerik:GridBoundColumn AllowSorting="true" DataType="System.String" DataField="Customer_Number" HeaderText="Customer Number" SortExpression="Customer_Number" UniqueName="Customer_Number" />
        <telerik:GridBoundColumn AllowSorting="false" DataType="System.String" DataField="Selected" HeaderText="Selected" UniqueName="Selected" />
        <telerik:GridBoundColumn AllowSorting="true" DataType="System.String" DataField="Customer_Name" HeaderText="Customer Name" SortExpression="Customer_Name" UniqueName="CustomerName" />
        <telerik:GridTemplateColumn HeaderText="Actions">
          <ItemTemplate>
            <asp:LinkButton ID="lbSelectCust" CommandArgument='<%# Eval("Customer_Number") %>'
              CommandName="CMD_CustSelect" Text="Select" Visible='<%# Eval("Selected").ToString() == "No" %>' runat="server" />
            &nbsp;&nbsp; 
                        <asp:LinkButton ID="lbDeleteCust" CommandArgument='<%# Eval("Customer_Number") %>'
                          CommandName="CMD_CustDelete" Text="Delete" Visible='<%# Eval("Selected").ToString() == "No" %>' runat="server" />
          </ItemTemplate>
        </telerik:GridTemplateColumn>
      </Columns>
    </MasterTableView>
  </telerik:RadGrid>
  <asp:HiddenField ID="hfAccount_Id" runat="server" />
  <asp:SqlDataSource ID="sqlCustomers" SelectCommand="
        SELECT cl.Customer_Id AS Customer_Id, c.Customer_Number,
         CASE (a.Customer_Id)
          WHEN cl.Customer_Id THEN 'Yes'
          ELSE 'No'
          END AS Selected,
         c.Customer_Name
         FROM WS_Account a
         INNER JOIN WS_CustomerList cl ON (a.Account_Id = cl.Account_Id)
         INNER JOIN AR_Customer c ON (cl.Customer_Id = c.Customer_Id)
         WHERE (a.Account_Id = @ID)
         ORDER BY c.Customer_Name;
        "
    runat="server">
    <SelectParameters>
      <asp:ControlParameter ControlID="hfAccount_Id" ConvertEmptyStringToNull="true" Name="ID"
        PropertyName="value" />
    </SelectParameters>
  </asp:SqlDataSource>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="cphScripts" runat="server">
  <script type="text/javascript">
    sw.setInactiveUrl = "<%= SetInactiveUrl%>";
    sw.activeLabel = "<%=ActiveLabel%>";
    sw.inactiveLabel = "<%=InactiveLabel%>";
    sw.activateLabel = "<%=ActivateLink%>";
    sw.deactivateLabel = "<%=DeactivateLink%>";
  </script>
</asp:Content>
