﻿<%@ Page Language="C#" MasterPageFile="~/inner.Master" AutoEventWireup="True"
	CodeBehind="default.aspx.cs" Inherits="SedonaWeb.customers._default" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="asp" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cphHead" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cphContent" runat="server">
	(Click Show Customer Search to open customer search tab)
	<br />
	<br />
    <script type="text/javascript">
    	function checkTextAreaMaxLength(textBox, e, length) {

    		var mLen = textBox["MaxLength"];
    		if (null == mLen)
    			mLen = length;

    		var maxLength = parseInt(mLen);
    		if (!checkSpecialKeys(e)) {
    			if (textBox.value.length > maxLength - 1) {
    				if (window.event)//IE
    					e.returnValue = false;
    				else//Firefox
    					e.preventDefault();
    			}
    		}
    	}
    	function checkSpecialKeys(e) {
    		if (e.keyCode != 8 && e.keyCode != 46 && e.keyCode != 37 && e.keyCode != 38 && e.keyCode != 39 && e.keyCode != 40)
    			return false;
    		else
    			return true;
    	}
    </script>
	<asp:HiddenField ID="hfCustomerNum" runat="server" />
	<asp:CollapsiblePanelExtender ID="cpeOverview" runat="Server" TargetControlID="pnlCustomerOverview"
		ExpandControlID="btnOverview" CollapseControlID="btnOverview" Collapsed="False" />
	<asp:CollapsiblePanelExtender ID="cpeAccount" runat="Server" TargetControlID="pnlCustomerAccountDetails"
		ExpandControlID="btnAccount" CollapseControlID="btnAccount" Collapsed="True" />
	<asp:Button ID="btnOverview" runat="server" Style="display: none"></asp:Button>
	<asp:Button ID="btnAccount" runat="server" Style="display: none"></asp:Button>
	<asp:Panel ID="pnlCustomerOverview" runat="server">
		<telerik:RadGrid ID="RadGridPaidInvoices" AllowSorting="True" OnItemCommand="RadGridPaidInvoices_ItemCommand"
			runat="server" AllowFilteringByColumn="True" AllowPaging="True" DataSourceID="SqlDataSource1"
			GridLines="None" Skin="" AutoGenerateColumns="False" >
			<GroupingSettings CaseSensitive="false" />
			<MasterTableView DataSourceID="SqlDataSource1">
				<Columns>
					<telerik:GridTemplateColumn DataField="CustomerNumber" HeaderText="Customer #" CurrentFilterFunction="StartsWith"
						AutoPostBackOnFilter="true" SortExpression="CustomerNumber" ShowFilterIcon="false">
						<ItemTemplate>
							<asp:LinkButton ID="lbSelectCust" runat="server" CommandArgument='<%# Eval("CustomerNumber") %>'
								CommandName="CMD_Select" Text='<%# Eval("CustomerNumber") %>'></asp:LinkButton>
						</ItemTemplate>
					</telerik:GridTemplateColumn>
					<telerik:GridBoundColumn DataField="CustomerName" HeaderText="Customer Name" CurrentFilterFunction="Contains"
						AutoPostBackOnFilter="true" SortExpression="CustomerName" ShowFilterIcon="false" />
					<telerik:GridBoundColumn DataField="SiteAddress" HeaderText="Address" CurrentFilterFunction="Contains" 
						AutoPostBackOnFilter="true" SortExpression="SiteAddress" ShowFilterIcon="false" />
					<telerik:GridBoundColumn DataField="SiteCity" HeaderText="City" CurrentFilterFunction="StartsWith" 
						AutoPostBackOnFilter="true" SortExpression="SiteCity" ShowFilterIcon="false" />
					<telerik:GridBoundColumn DataField="SiteState" HeaderText="State" CurrentFilterFunction="StartsWith" 
						AutoPostBackOnFilter="true" SortExpression="SiteState" ShowFilterIcon="false" />
					<telerik:GridBoundColumn DataField="SitePostal" HeaderText="Zip Code" CurrentFilterFunction="StartsWith" 
						AutoPostBackOnFilter="true" SortExpression="SitePostal" ShowFilterIcon="false" />
					<telerik:GridBoundColumn DataField="AlarmAccount" HeaderText="System/Alarm#" CurrentFilterFunction="StartsWith" 
						AutoPostBackOnFilter="true" SortExpression="AlarmAccount" ShowFilterIcon="false" />
				</Columns>
			</MasterTableView>
		</telerik:RadGrid>
		<asp:SqlDataSource ID="SqlDataSource1" runat="server"></asp:SqlDataSource>
	</asp:Panel>
	<br />
	<br />
	<br />
	<asp:Panel ID="pnlCustomerAccountDetails" runat="server">
		<asp:Panel ID="pnlCustomerDetails" runat="server" Visible="false">
			<table class="DetailSheet">
				<tr>
					<td width="33%" valign="top" align="left">
						<b>Account#</b><asp:Label ID="lblCustNum" runat="server"></asp:Label>
					</td>
					<td width="33%" valign="top">
						<table>
							<tr>
								<th>
									Current Balance Due
								</th>
								<td>
									<asp:Label ID="lblCurrentBalDue" runat="server"></asp:Label>
								</td>
							</tr>
							<tr>
								<th>
									Active RMR
								</th>
								<td>
									<asp:Label ID="lblActiveRMR" runat="server"></asp:Label>
								</td>
							</tr>
							<tr>
								<th>
									Customer Type
								</th>
								<td>
									<asp:Label ID="lblCustType" runat="server"></asp:Label>
								</td>
							</tr>
							<tr>
								<th>
									Auto Pay
								</th>
								<td>
									<asp:Label ID="lblAutoPay" runat="server"></asp:Label>
								</td>
							</tr>
							<tr>
								<th>
									Collection Status
								</th>
								<td>
									<asp:Label ID="lblCollectionStatus" runat="server"></asp:Label>
								</td>
							</tr>
							<tr>
								<th>
									Last Statement Date
								</th>
								<td>
									<asp:Label ID="lblLastStatement" runat="server"></asp:Label>
								</td>
							</tr>
							<tr>
								<th>
									Salesperson
								</th>
								<td>
									<asp:Label ID="lblsales" runat="server"></asp:Label>
								</td>
							</tr>
						</table>
					</td>
					<td width="33%" valign="top" align="left">
						<table>
							<tr>
								<th>
									<b>Customer Branch:</b>
								</th>
								<td>
									<asp:Label ID="lblCustomerBranch" runat="server"></asp:Label>
								</td>
							</tr>
							<tr>
								<th>
									<b>Customer Status:</b>
								</th>
								<td>
									<asp:Label ID="lblCustomerStatus" runat="server"></asp:Label>
								</td>
							</tr>
                        </table>
					</td>
				</tr>
			</table>
			<br />
			<table class="CustDetailOptions">
				<tr id="trInvoices" runat="server">
					<td>
						<asp:LinkButton ID="lbIOpen" runat="server" OnClick="lbIOpen_Click">Open Invoices</asp:LinkButton>
					</td>
					<td>
						<asp:LinkButton ID="lbIPaid" runat="server" OnClick="lbIPaid_Click">Paid Invoices</asp:LinkButton>
					</td>
					<td>
						<asp:LinkButton ID="lbPayments" runat="server" OnClick="lbPayments_Click">Payments</asp:LinkButton>
					</td>
					<td>
						<asp:LinkButton ID="lbLedger" runat="server" OnClick="lbLedger_Click">View Ledger</asp:LinkButton>
					</td>
				</tr>
				<tr runat="server" id="trTickets">
					<td>
						<asp:LinkButton ID="lbTOpen" runat="server" OnClick="lbTOpen_Click">Open Tickets</asp:LinkButton>
					</td>
					<td>
						<asp:LinkButton ID="lbTClosed" runat="server" OnClick="lbTClosed_Click">Closed Tickets</asp:LinkButton>
					</td>
					<td>
						<asp:HyperLink ID="lbTNew" Target="ifDetails" runat="server">Create New Ticket</asp:HyperLink>
					</td>
					<td>
					</td>
				</tr>
				<tr>
					<td>
						<asp:LinkButton ID="lbCView" runat="server" OnClick="lbCView_Click">View Contacts</asp:LinkButton>
					</td>
					<td>
						<asp:LinkButton ID="lbRecurring" runat="server" OnClick="lbRecurring_Click">Recurring Services</asp:LinkButton>
					</td>
					<td>
						<asp:LinkButton ID="lbCustomerNotes" runat="server" OnClick="lbCustomerNotes_Click">Customer Notes</asp:LinkButton>
					</td>
				</tr>
			</table>
		</asp:Panel>
		<!-- Individual Panels Begin -->
		<asp:Panel ID="pnlIOpen" runat="server" Visible="false">
			<br />
			<h2>
				Open Invoices</h2>
			<br />
			<telerik:RadGrid ID="radIOpen" runat="server" AutoGenerateColumns="false" AllowSorting="True"
				DataSourceID="sqlIOpen" GridLines="None" AllowPaging="True">
				<MasterTableView>
					<RowIndicatorColumn>
						<HeaderStyle Width="20px"></HeaderStyle>
					</RowIndicatorColumn>
					<ExpandCollapseColumn>
						<HeaderStyle Width="20px"></HeaderStyle>
					</ExpandCollapseColumn>
					<Columns>
						<telerik:GridTemplateColumn HeaderText="Invoice #" SortExpression="Invoice_Number">
							<ItemTemplate>
								<a target="ifDetails" href='<%# "/invoices/invoice.aspx?invoice=" + Uri.EscapeDataString(DataBinder.Eval(Container.DataItem, "Invoice_Number").ToString())+"&HideNav=y" %>'>
									<%# Eval("Invoice_Number")  %></a>
							</ItemTemplate>
						</telerik:GridTemplateColumn>
						<telerik:GridBoundColumn DataField="Invoice_Date" SortExpression="Invoice_Date" HeaderText="Date" DataFormatString="{0:M/d/yyyy}" />
						<telerik:GridBoundColumn DataField="Inv_Desc_Code" SortExpression="Inv_Desc_Code" HeaderText="Description" />
						<telerik:GridBoundColumn DataField="Amount" SortExpression="Amount" HeaderText="Amount" DataFormatString="{0:C}" />
						<telerik:GridBoundColumn DataField="Net_Due" SortExpression="	Net_Due" HeaderText="Net Due" DataFormatString="{0:C}" />
					</Columns>
				</MasterTableView>
			</telerik:RadGrid>
			<asp:SqlDataSource ID="sqlIOpen" SelectCommand="DECLARE @CustID AS INT
 SET @CustID =(SELECT Customer_Id FROM AR_Customer WHERE Customer_Number = @ID)
 SELECT cb.Commercial, cb.Business_Name, cb.First_Name + ' ' + cb.Last_Name AS ResName, 
				inv.Invoice_Number, inv.Invoice_Date, inv.Amount,   
				 inv.Net_Due, inv.Invoice_Id, inv.Customer_Site_Id, ds.Inv_Desc_Code, sub.Business_Name AS Sub_business_Name,  
				inv.Alarm_Account, ISNULL (inv.Payment_Date, '1899/12/30') AS Payment_Date,  
				ISNULL((SELECT SUM(achinv.Amount) FROM AR_ACH_Invoice achinv INNER JOIN AR_ACH ach ON achinv.ACH_Id = ach.ACH_Id 
				WHERE (ach.Voided = 'N') AND (ach.Response_Type &lt;&gt; 'D') AND (ach.Posted = 'N') AND (achinv.Invoice_Id = inv.Invoice_id)),0) AS Pending_Payment  
 From AR_Invoice inv 
				INNER JOIN AR_Customer_Bill cb ON cb.Customer_Bill_Id = inv.Customer_Bill_Id   
				INNER JOIN AR_Customer_Site csi ON csi.Customer_Site_Id = inv.Customer_Site_Id   
				INNER JOIN AR_Invoice_Description ds ON ds.Inv_Desc_ID = inv.Invoice_Description_Id   
				INNER JOIN AR_Customer_Site sub ON sub.Customer_Site_Id = inv.Sub_Customer_Site_Id 
 WHERE (inv.customer_id = @CustID) AND (inv.Net_Due &gt; 0) 
 ORDER BY Invoice_Date DESC" runat="server">
				<SelectParameters>
					<asp:ControlParameter ControlID="hfCustomerNum" ConvertEmptyStringToNull="true" Name="ID"
						PropertyName="value" />
				</SelectParameters>
			</asp:SqlDataSource>
		</asp:Panel>
		<asp:Panel ID="pnlIPaid" runat="server" Visible="false">
			<br />
			<h2>
				Paid Invoices</h2>
			<br />
			<telerik:RadGrid ID="radIPaid" AutoGenerateColumns="false" runat="server" AllowSorting="True"
				DataSourceID="sqlIPaid" GridLines="None" AllowPaging="True">
				<MasterTableView>
					<RowIndicatorColumn>
						<HeaderStyle Width="20px"></HeaderStyle>
					</RowIndicatorColumn>
					<ExpandCollapseColumn>
						<HeaderStyle Width="20px"></HeaderStyle>
					</ExpandCollapseColumn>
					<Columns>
						<telerik:GridTemplateColumn HeaderText="Invoice #" SortExpression="Invoice_Number">
							<ItemTemplate>
								<a target="ifDetails" href='<%# "/invoices/invoice.aspx?invoice=" + Uri.EscapeDataString(DataBinder.Eval(Container.DataItem, "Invoice_Number").ToString())+"&HideNav=y" %>'>
									<%# Eval("Invoice_Number")  %></a>
							</ItemTemplate>
						</telerik:GridTemplateColumn>
						<telerik:GridBoundColumn DataField="Invoice_Date" SortExpression="Invoice_Date" HeaderText="Date" DataFormatString="{0:M/d/yyyy}" />
						<telerik:GridBoundColumn DataField="Inv_Desc_Code" SortExpression="Inv_Desc_Code" HeaderText="Description" />
						<telerik:GridBoundColumn DataField="Amount" SortExpression="Amount" HeaderText="Amount" DataFormatString="{0:C}" />
					</Columns>
				</MasterTableView>
			</telerik:RadGrid>
			<asp:SqlDataSource ID="sqlIPaid" SelectCommand="DECLARE @CustID AS INT 
SET @CustID =(SELECT Customer_Id FROM AR_Customer WHERE Customer_Number = @ID) 
SELECT cb.Commercial, cb.Business_Name, cb.First_Name + ' ' + cb.Last_Name AS ResName,  
				inv.Invoice_Number, inv.Invoice_Date, inv.Amount,   
				 inv.Net_Due, inv.Invoice_Id, inv.Customer_Site_Id, ds.Inv_Desc_Code, sub.Business_Name AS Sub_business_Name,  
				inv.Alarm_Account, ISNULL (inv.Payment_Date, '1899/12/30') AS Payment_Date,   
				ISNULL((SELECT SUM(achinv.Amount) FROM AR_ACH_Invoice achinv INNER JOIN AR_ACH ach ON achinv.ACH_Id = ach.ACH_Id  
				WHERE (ach.Voided = 'N') AND (ach.Response_Type &lt;&gt; 'D') AND (ach.Posted = 'N') AND (achinv.Invoice_Id = inv.Invoice_id)),0) AS Pending_Payment 
From AR_Invoice inv 
				INNER JOIN AR_Customer_Bill cb ON cb.Customer_Bill_Id = inv.Customer_Bill_Id  
				INNER JOIN AR_Customer_Site csi ON csi.Customer_Site_Id = inv.Customer_Site_Id   
				INNER JOIN AR_Invoice_Description ds ON ds.Inv_Desc_ID = inv.Invoice_Description_Id   
				INNER JOIN AR_Customer_Site sub ON sub.Customer_Site_Id = inv.Sub_Customer_Site_Id 
WHERE (inv.customer_id = @CustID) AND (inv.Net_Due = 0)
ORDER BY Invoice_Date DESC" runat="server">
				<SelectParameters>
					<asp:ControlParameter ControlID="hfCustomerNum" ConvertEmptyStringToNull="true" Name="ID"
						PropertyName="value" />
				</SelectParameters>
			</asp:SqlDataSource>
		</asp:Panel>
		<asp:Panel ID="pnlPayments" runat="server" Visible="false">
			<br />
			<h2>
				Payments</h2>
			<br />
			<telerik:RadGrid ID="radPayments" AutoGenerateColumns="false" runat="server" AllowSorting="True"
				DataSourceID="sqlPayments" GridLines="None" AllowPaging="True">
				<MasterTableView>
					<RowIndicatorColumn>
						<HeaderStyle Width="20px"></HeaderStyle>
					</RowIndicatorColumn>
					<ExpandCollapseColumn>
						<HeaderStyle Width="20px"></HeaderStyle>
					</ExpandCollapseColumn>
					<Columns>
						<telerik:GridBoundColumn DataField="Transaction_Date" SortExpression="Transaction_Date" HeaderText="Date" DataFormatString="{0:M/d/yyyy}" />
						<telerik:GridBoundColumn DataField="Check_Number" SortExpression="Check_Number" HeaderText="Check #" />
						<telerik:GridBoundColumn DataField="Amount" SortExpression="Amount" HeaderText="Amount" DataFormatString="{0:C}" />
						<telerik:GridBoundColumn DataField="Memo" SortExpression="Memo" HeaderText="Memo" />
					</Columns>
				</MasterTableView>
			</telerik:RadGrid>
			<asp:SqlDataSource ID="sqlPayments" SelectCommand="DECLARE @CustID AS INT
SET @CustID = (SELECT Customer_Id FROM AR_Customer WHERE Customer_Number = @ID) 
SELECT dc.Deposit_Check_Id, dc.Transaction_Date, pm.Payment_Method_Code, 
dc.Check_Number, dc.Amount, dc.Memo, dc.Check_Date 
FROM AR_Deposit_Check dc 
	INNER JOIN AR_Payment_Method pm ON pm.Payment_Method_Id = dc.Payment_Method_Id 
WHERE dc.Customer_Id = @CustID 
ORDER BY Transaction_Date DESC" runat="server">
				<SelectParameters>
					<asp:ControlParameter ControlID="hfCustomerNum" ConvertEmptyStringToNull="true" Name="ID"
						PropertyName="value" />
				</SelectParameters>
			</asp:SqlDataSource>
		</asp:Panel>
		<asp:Panel ID="pnlLedger" runat="server" Visible="false">
			<br />
			<h2>
				Ledger</h2>
			<br />
			<telerik:RadGrid ID="radLedger" AutoGenerateColumns="false" OnDataBound="radLedger_DataBound"
				runat="server" AllowSorting="True" GridLines="None" OnNeedDataSource="_HandleLedgerNeedsDataSource"
				AllowPaging="True">
				<MasterTableView>
					<RowIndicatorColumn>
						<HeaderStyle Width="20px"></HeaderStyle>
					</RowIndicatorColumn>
					<ExpandCollapseColumn>
						<HeaderStyle Width="20px"></HeaderStyle>
					</ExpandCollapseColumn>
					<Columns>
						<telerik:GridBoundColumn DataField="Trans_Type" SortExpression="Trans_Type" HeaderText="Type" />
						<telerik:GridBoundColumn DataField="Trans_Date" SortExpression="Trans_Date" HeaderText="Date" DataFormatString="{0:d}" />
						<telerik:GridBoundColumn DataField="Trans_Description" SortExpression="Trans_Description" HeaderText="Description" />
						<telerik:GridTemplateColumn HeaderText="Transaction">
							<ItemTemplate>
								<%# (Eval("sort_code").ToString() == "1" || Eval("sort_code").ToString() == "3" || Eval("sort_code").ToString() == "6" || Eval("sort_code").ToString() == "8" || Eval("sort_code").ToString() == "A" ? double.Parse(Eval("Amount").ToString()).ToString("c") : "")%>
							</ItemTemplate>
						</telerik:GridTemplateColumn>
						<telerik:GridTemplateColumn HeaderText="Payments">
							<ItemTemplate>
								<%# (Eval("sort_code").ToString() == "2" || Eval("sort_code").ToString() == "4" ? double.Parse(Eval("Amount").ToString()).ToString("c") : "")%>
							</ItemTemplate>
						</telerik:GridTemplateColumn>
						<telerik:GridTemplateColumn HeaderText="Invoices">
							<ItemTemplate>
								<%# (Eval("sort_code").ToString() == "0"  ? double.Parse(Eval("Amount").ToString()).ToString("c") : "")%>
							</ItemTemplate>
						</telerik:GridTemplateColumn>
						<telerik:GridTemplateColumn HeaderText="Balance">
							<ItemTemplate>
								<%# Eval("RunningTotal", "{0:c}") %>
							</ItemTemplate>
						</telerik:GridTemplateColumn>
					</Columns>
				</MasterTableView>
			</telerik:RadGrid>
		</asp:Panel>
		<asp:Panel ID="pnlTOpen" runat="server" Visible="false">
			<br />
			<h2>
				Open Ticket</h2>
			<br />
			<telerik:RadGrid ID="radTOpen" runat="server" AutoGenerateColumns="false" AllowSorting="True"
				DataSourceID="sqlTOpen" GridLines="None" AllowPaging="True">
				<MasterTableView>
					<RowIndicatorColumn>
						<HeaderStyle Width="20px"></HeaderStyle>
					</RowIndicatorColumn>
					<ExpandCollapseColumn>
						<HeaderStyle Width="20px"></HeaderStyle>
					</ExpandCollapseColumn>
					<Columns>
						<telerik:GridTemplateColumn HeaderText="Ticket #" SortExpression="TicketNumber">
							<ItemTemplate>
								<asp:HyperLink ID='HyperLinkInvoiceDetail' NavigateUrl='<%# "/service_tickets/service.aspx?ticket=" + Uri.EscapeDataString(DataBinder.Eval(Container.DataItem, "TicketNumber").ToString())+"&HideNav=y" %>'
									runat='server' Text='<%# DataBinder.Eval(Container.DataItem, "TicketNumber") %>'
									Target="ifDetails" />
							</ItemTemplate>
						</telerik:GridTemplateColumn>
						<telerik:GridBoundColumn DataField="SiteName" SortExpression="SiteName" HeaderText="Site" />
						<telerik:GridBoundColumn DataField="SystemCode" SortExpression="SystemCode" HeaderText="System" />
						<telerik:GridBoundColumn DataField="CreatedOn" SortExpression="CreatedOn" HeaderText="Created" DataFormatString="{0:d}" />
						<telerik:GridBoundColumn DataField="ProblemCode" SortExpression="ProblemCode" HeaderText=" " />
					</Columns>
				</MasterTableView>
			</telerik:RadGrid>
			<asp:SqlDataSource ID="sqlTOpen" SelectCommand="DECLARE @CustID AS INT   
 SET @CustID = (SELECT Customer_Id FROM AR_Customer WHERE Customer_Number =@ID)  
 SELECT st.Service_Ticket_Id AS Ticket_Id, st.Ticket_Number AS TicketNumber, st.Customer_Id AS Customer_Id,   
		 st.Ticket_Status AS TicketStatus, st.Customer_Site_Id AS Site_Id, st.Customer_System_Id AS System_Id,   
		 st.Requested_By AS RequestedBy, st.Requested_By_Phone AS RequestedByPhone, st.CustomerComments AS CustomerComments,   
		 pr.Description AS PriorityCode, res.Resolution_Code AS ResolutionCode, pc.Problem_Code AS ProblemCode,    
		 csy.Alarm_Account AS AlarmAccount,st.Creation_Date AS CreatedOn,   
		 sys.System_Code AS SystemCode, cst.Address_1 AS SiteAddress,   
		 st.ClosedDate, cst.Business_Name AS SiteName   
 FROM SV_Service_Ticket st    
		 INNER JOIN SV_Problem pc ON st.Problem_Id = pc.Problem_Id    
		 INNER JOIN SS_Priority pr ON st.Priority_Id = pr.Priority_Id    
		 INNER JOIN SV_Resolution res ON st.Resolution_Id = res.Resolution_Id    
		 INNER JOIN AR_Customer_Site cst ON st.Customer_Site_Id = cst.Customer_Site_Id    
		 INNER JOIN AR_Customer_System csy ON st.Customer_System_Id = csy.Customer_System_Id    
		 INNER JOIN SY_System sys ON csy.System_Id = sys.System_Id  
 WHERE st.customer_id = @CustID  
				AND ticket_status &lt;&gt; 'CL'  
 ORDER BY CreatedOn DESC" runat="server">
				<SelectParameters>
					<asp:ControlParameter ControlID="hfCustomerNum" ConvertEmptyStringToNull="true" Name="ID"
						PropertyName="value" />
				</SelectParameters>
			</asp:SqlDataSource>
		</asp:Panel>
		<asp:Panel ID="pnlTClosed" runat="server" Visible="false">
			<br />
			<h2>
				Closed Tickets</h2>
			<br />
			<telerik:RadGrid ID="radTClosed" AutoGenerateColumns="false" runat="server" AllowSorting="True"
				DataSourceID="sqlTClosed" GridLines="None" AllowPaging="True">
				<MasterTableView>
					<RowIndicatorColumn>
						<HeaderStyle Width="20px"></HeaderStyle>
					</RowIndicatorColumn>
					<ExpandCollapseColumn>
						<HeaderStyle Width="20px"></HeaderStyle>
					</ExpandCollapseColumn>
					<Columns>
						<telerik:GridTemplateColumn HeaderText="Ticket #" SortExpression="TicketNumber">
							<ItemTemplate>
								<asp:HyperLink ID='HyperLinkInvoiceDetail' NavigateUrl='<%# "/service_tickets/service.aspx?ticket=" + Uri.EscapeDataString(DataBinder.Eval(Container.DataItem, "TicketNumber").ToString())+"&HideNav=y" %>'
									runat='server' Text='<%# DataBinder.Eval(Container.DataItem, "TicketNumber") %>'
									Target="ifDetails" />
							</ItemTemplate>
						</telerik:GridTemplateColumn>
						<telerik:GridBoundColumn DataField="SiteName" SortExpression="SiteName" HeaderText="Site" />
						<telerik:GridBoundColumn DataField="AlarmAccount" SortExpression="AlarmAccount" HeaderText="Account" />
						<telerik:GridBoundColumn DataField="SystemCode" SortExpression="SystemCode" HeaderText="System" />
						<telerik:GridBoundColumn DataField="CreatedOn" SortExpression="CreatedOn" HeaderText="Created" DataFormatString="{0:d}" />
						<telerik:GridBoundColumn DataField="ProblemCode" SortExpression="ProblemCode" HeaderText="Problem" />
						<telerik:GridBoundColumn DataField="ResolutionCode" SortExpression="ResolutionCode" HeaderText="ResolutionCode" />
					</Columns>
				</MasterTableView>
			</telerik:RadGrid>
			<asp:SqlDataSource ID="sqlTClosed" SelectCommand="DECLARE @CustID AS INT   
 SET @CustID = (SELECT Customer_Id FROM AR_Customer WHERE Customer_Number =@ID)  
 SELECT st.Service_Ticket_Id AS Ticket_Id, st.Ticket_Number AS TicketNumber, st.Customer_Id AS Customer_Id,   
		 st.Ticket_Status AS TicketStatus, st.Customer_Site_Id AS Site_Id, st.Customer_System_Id AS System_Id,   
		 st.Requested_By AS RequestedBy, st.Requested_By_Phone AS RequestedByPhone, st.CustomerComments AS CustomerComments,   
		 pr.Description AS PriorityCode, res.Resolution_Code AS ResolutionCode, pc.Problem_Code AS ProblemCode,    
		 csy.Alarm_Account AS AlarmAccount,st.Creation_Date AS CreatedOn,   
		 sys.System_Code AS SystemCode, cst.Address_1 AS SiteAddress,   
		 st.ClosedDate, cst.Business_Name AS SiteName   
 FROM SV_Service_Ticket st    
		 INNER JOIN SV_Problem pc ON st.Problem_Id = pc.Problem_Id    
		 INNER JOIN SS_Priority pr ON st.Priority_Id = pr.Priority_Id    
		 INNER JOIN SV_Resolution res ON st.Resolution_Id = res.Resolution_Id    
		 INNER JOIN AR_Customer_Site cst ON st.Customer_Site_Id = cst.Customer_Site_Id    
		 INNER JOIN AR_Customer_System csy ON st.Customer_System_Id = csy.Customer_System_Id    
		 INNER JOIN SY_System sys ON csy.System_Id = sys.System_Id  
 WHERE st.customer_id = @CustID  
				AND ticket_status = 'CL'  
 ORDER BY CreatedOn DESC" runat="server">
				<SelectParameters>
					<asp:ControlParameter ControlID="hfCustomerNum" ConvertEmptyStringToNull="true" Name="ID"
						PropertyName="value" />
				</SelectParameters>
			</asp:SqlDataSource>
		</asp:Panel>
		<asp:Panel ID="pnlContacts" runat="server" Visible="false">
			<br />
			<h2>
				Contacts
            </h2>
			<br />
			<telerik:RadGrid ID="radContacts" runat="server" AllowSorting="True" DataSourceID="sqlContacts"
				GridLines="None" AllowPaging="True" AutoGenerateColumns="false">
				<MasterTableView>
					<RowIndicatorColumn>
						<HeaderStyle Width="20px"></HeaderStyle>
					</RowIndicatorColumn>
					<ExpandCollapseColumn>
						<HeaderStyle Width="20px"></HeaderStyle>
					</ExpandCollapseColumn>
					<Columns>
						<telerik:GridBoundColumn DataField="Contact_Name" SortExpression="Contact_Name" HeaderText="Name" />
						<telerik:GridBoundColumn DataField="Contact_Phone" SortExpression="Contact_Phone" HeaderText="Phone" />
						<telerik:GridBoundColumn DataField="Contact_Fax" SortExpression="Contact_Fax" HeaderText="Fax" />
						<telerik:GridTemplateColumn HeaderText="E-Mail" SortExpression="E_Mail">
							<ItemTemplate>
								<a href='<%#"mailto:"+ Eval("E_Mail") %>'>
									<%# Eval("E_Mail")  %></a>
							</ItemTemplate>
						</telerik:GridTemplateColumn>
					</Columns>
				</MasterTableView>
			</telerik:RadGrid>
			<asp:SqlDataSource ID="sqlContacts" SelectCommand="DECLARE @CustID AS INT  
 SET @CustID = (SELECT Customer_Id FROM AR_Customer WHERE Customer_Number =@ID)  
 SELECT c.Customer_Contact_Id, c.Contact_Name, c.Title, c.Phone AS Contact_Phone,   
 c.Extension, c.Fax AS Contact_Fax, c.Pager AS Contact_Pager, c.E_Mail   
 FROM AR_Customer_Contact c   
 WHERE (EXISTS(SELECT * FROM AR_Site_Contact stc  
 INNER JOIN AR_Customer_Site st ON stc.Site_Id = st.Customer_Site_Id   
 WHERE (stc.Contact_Id = c.Customer_Contact_Id) AND (st.customer_id = @CustID))   
 OR EXISTS(SELECT * FROM AR_Bill_Contact cbc    
 INNER JOIN AR_Customer_Bill cb ON cbc.Bill_Id = cb.Customer_Bill_Id   
 WHERE (cbc.Contact_Id = c.Customer_Contact_Id) AND (cb.customer_id = @CustID))) " runat="server">
				<SelectParameters>
					<asp:ControlParameter ControlID="hfCustomerNum" ConvertEmptyStringToNull="true" Name="ID"
						PropertyName="value" />
				</SelectParameters>
			</asp:SqlDataSource>
		</asp:Panel>
		<asp:Panel ID="pnlRecurring" runat="server" Visible="false">
			<br />
			<h2>
				Recurring Services</h2>
			<br />
			<telerik:RadGrid ID="radRecurring" runat="server" AllowSorting="True" DataSourceID="sqlRecurring"
				GridLines="None" AllowPaging="True">
				<MasterTableView AutoGenerateColumns="false" DataSourceID="sqlRecurring" ShowFooter="True">
					<RowIndicatorColumn>
						<HeaderStyle Width="20px"></HeaderStyle>
					</RowIndicatorColumn>
					<ExpandCollapseColumn>
						<HeaderStyle Width="20px"></HeaderStyle>
					</ExpandCollapseColumn>
					<CommandItemSettings ExportToPdfText="Export to Pdf" />
					<Columns>
						<telerik:GridBoundColumn DataField="Item_Code" SortExpression="Item_Code" HeaderText="Item Code" />
						<telerik:GridBoundColumn DataField="Description" SortExpression="Description" HeaderText="Description" />
						<telerik:GridBoundColumn DataField="Alarm_Account" SortExpression="Alarm_Account" HeaderText="Account #" />
						<telerik:GridBoundColumn DataField="Cycle_Start_Date" SortExpression="Cycle_Start_Date"
							HeaderText="Activation Date" DataFormatString="{0:d}" />
						<telerik:GridBoundColumn DataField="Next_Cycle_Date" SortExpression="Next_Cycle_Date"
							HeaderText="Next Billing Date" DataFormatString="{0:d}" />
						<telerik:GridBoundColumn DataField="Bill_Cycle" SortExpression="Bill_Cycle" HeaderText="Frequency" />
						<telerik:GridBoundColumn DataField="monthly_amount" SortExpression="monthly_amount"
							DataType="System.Decimal" DataFormatString="{0:C}" Aggregate="Sum" HeaderText="RMR Amount" />
						<telerik:GridBoundColumn DataField="Cycle_End_Date" SortExpression="Cycle_End_Date"
							HeaderText="End Date" DataFormatString="{0:d}" />
					</Columns>
				</MasterTableView>
			</telerik:RadGrid>
			<asp:SqlDataSource ID="sqlRecurring" SelectCommand="DECLARE @CustID AS INT  
 SET @CustID = (SELECT Customer_Id FROM AR_Customer WHERE Customer_Number =@ID)  
 SELECT r.Customer_Recurring_id, cs.Alarm_Account, s.System_Code, i.Item_Code, i.Description, r.monthly_amount,    
			  r.Next_Cycle_Date, r.Cycle_Start_Date, 
              Cycle_End_Date = (CASE WHEN r.Cycle_End_Date < 0.0 THEN 'None' ELSE CONVERT(VARCHAR(50), CONVERT(VARCHAR(11), r.Cycle_End_Date, 101)) END), 
              r.Pending_Amt, Bill_Cycle,
              r.Customer_Site_Id, r.Customer_System_id, r.Cancelled, r.Master_Item_id, r.Cycle_Amount   
			  FROM AR_Customer_Recurring r   
			  INNER JOIN AR_Item i ON i.Item_id = r.Item_id   
			  INNER JOIN AR_Customer_System cs ON cs.Customer_System_Id = r.Customer_System_id   
			  INNER JOIN SY_System s ON s.System_id = cs.System_id    
 WHERE r.Customer_Id =   @CustID   
			  AND (r.Cycle_End_Date &lt; 0.0 OR r.Cycle_End_Date &gt; GETDATE())" runat="server">
				<SelectParameters>
					<asp:ControlParameter ControlID="hfCustomerNum" ConvertEmptyStringToNull="true" Name="ID"
						PropertyName="value" />
				</SelectParameters>
			</asp:SqlDataSource>
		</asp:Panel>
		<asp:Panel ID="pnlNotes" runat="server" Visible="false">
			<br />
			<h2>
				Notes</h2>
			<br />
			<telerik:RadGrid ID="radNotes" runat="server" AllowSorting="True" DataSourceID="sqlNotes"
				GridLines="None" AllowPaging="True">
				<MasterTableView AutoGenerateColumns="false">
					<RowIndicatorColumn>
						<HeaderStyle Width="20px"></HeaderStyle>
					</RowIndicatorColumn>
					<ExpandCollapseColumn>
						<HeaderStyle Width="20px"></HeaderStyle>
					</ExpandCollapseColumn>
					<Columns>
						<telerik:GridDateTimeColumn HeaderText="Date" DataField="Note_Date" DataFormatString="{0:d}" />
						<telerik:GridBoundColumn HeaderText="User" DataField="UserName" />
						<telerik:GridBoundColumn HeaderText="Note" DataField="Notes" />
					</Columns>
				</MasterTableView>
			</telerik:RadGrid>
			<asp:SqlDataSource ID="sqlNotes" SelectCommand="DECLARE @CustID AS INT 
SET @CustID = (SELECT Customer_Id FROM AR_Customer WHERE Customer_Number = @ID) 
SELECT Customer_Notes_Id, Customer_Id, UserName, Note_Date, Notes 
FROM AR_Customer_Notes 
WHERE Customer_Id = @CustID AND Access_Level = 1
ORDER BY Note_Date DESC, UserName " runat="server">
				<SelectParameters>
					<asp:ControlParameter ControlID="hfCustomerNum" ConvertEmptyStringToNull="true" Name="ID"
						PropertyName="value" />
				</SelectParameters>
			</asp:SqlDataSource>
			<asp:Panel ID="pnlNotesAdd" runat="server" >
			<br />
			Type a note below.
			<br />
			<asp:TextBox ID="txtNote" TextMode="MultiLine" CssClass="TextArea" Width="400px"
				Height="200px" runat="server" />
			<br />
			<asp:Button ID="btnAddNote" runat="server" Text="Add Note" OnClick="lbAddNote_Click" />
			<asp:Button ID="btnCancel" runat="server" Text="Cancel" OnClick="btnCancel_Click" />
			</asp:Panel>
		</asp:Panel>
		<!-- Individual Panels End -->
		<asp:Panel ID="pnlIframe" runat="server">
			<asp:HtmlIframe id="ifDetails2" runat="server" name="ifDetails" width="100%" height="300px"
				frameborder="0" marginheight="0px" marginwidth="0px"></asp:HtmlIframe>
		</asp:Panel>
	</asp:Panel>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="cphScripts" runat="server">
</asp:Content>
