﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="EmailCustomerNumber.aspx.cs" Inherits="SedonaWeb.EmailCustomerNumber" %>

<%@ Register Src="/Customizable/outside_Header.ascx" TagName="outside_Header" TagPrefix="uc2" %>
<%@ Register Src="/Customizable/outside_footer.ascx" TagName="outside_footer" TagPrefix="uc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <%= SedonaWeb.SWSCore.WebSettings.PageHeadInclude %>
    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <link href="/css/global.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
        <div id="formContainer">
            <uc2:outside_Header ID="outside" runat="server" />
            <asp:Panel ID="SuccessPanel" Visible="False" runat="server">
                <asp:Label CssClass="pageTitle" runat="server" Text="Email Customer Number Confirmation." />
                <asp:Label CssClass="pageDes" runat="server" Text="Please check your email for customer number information." />
            </asp:Panel>
            <asp:Panel ID="EntryPanel" runat="server">
                <asp:Label CssClass="pageTitle" runat="server" Text="Email Customer Number" />
                <asp:Label CssClass="pageDes" runat="server" Text="Enter your email address or phone number." />
                <asp:Label ID="txtError" Visible="false" CssClass="error_message_small" runat="server" />
                <asp:Panel ID="PanelEmail" runat="server">
                    <asp:Label ID="LabelEmail" CssClass="inputLabel" runat="server">
                        <asp:Label ID="LabelEmail2" runat="server" Text="Email" />
                    </asp:Label>
                    <asp:TextBox ID="txtEmail" Columns="50" MaxLength="50" runat="server" CssClass="inputBox" CausesValidation="true" />
                    <asp:CustomValidator ID="cvEmail" ControlToValidate="txtEmail" CssClass="error_message_small" Display="Dynamic"
                        ErrorMessage="Invalid format!" OnServerValidate="ValidateEmail" runat="server" />
                </asp:Panel>
                <h5>If submitting email address, a phone number is not required and would be ignored.</h5>
                <br />
                <asp:Panel ID="PanelPhone" runat="server">
                    <asp:Label ID="LabelPhone" CssClass="inputLabel" runat="server">
                        <asp:Label ID="LabelPhone2" runat="server" Text="Phone Number" />
                    </asp:Label>
                    <asp:TextBox ID="txtPhone" Columns="25" MaxLength="25" runat="server" CssClass="inputBox" />
                </asp:Panel>
                <h5>If submitting phone number, the email address attached to the same record as the phone number will be sent the customer number information.</h5>
                <br />
                <asp:Panel ID="PanelSubmit" runat="server">
                    <asp:Label ID="LabelSubmit" CssClass="inputLabel" runat="server">
                        <asp:Label ID="LabelSubmit2" CssClass="inputLabel" runat="server" />
                    </asp:Label>
                    <asp:Button ID="btnSubmit" runat="server" Text="Submit" OnClick="Submit" UseSubmitBehavior="false"
                        OnClientClick="{ btnSubmit.Enabled = false; btnSubmit.value = 'Processing...'; __doPostBack('btnSubmit',''); }" />
                </asp:Panel>
            </asp:Panel>
            <uc1:outside_footer ID="footer" runat="server" />
        </div>
    </form>

    <script type="text/javascript">
        var e = document.getElementById("txtEmail");
        e.addEventListener("blur", validateRequired)
        var p = document.getElementById("txtPhone");
        p.addEventListener("blur", validateRequired)

        function validateRequired() {
            var email = e.value;
            var phone = p.value;
            email = email.trim();
            phone = phone.trim();

            if (email.length > 0 || phone.length > 0) {
                x = document.getElementById("txtError");
                x.hidden = true;
            }
        }
    </script>

</body>
</html>
