﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ConvertAccountEmail.aspx.cs" Inherits="SedonaWeb.ConvertAccountEmail" %>

<%@ Register Src="/Customizable/outside_footer.ascx" TagName="outside_footer" TagPrefix="uc1" %>
<%@ Register Src="/Customizable/outside_Header.ascx" TagName="outside_Header" TagPrefix="uc2" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
  <%= SedonaWeb.SWSCore.WebSettings.PageHeadInclude %>
	<link href="/css/global.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <div id="formContainer">
	    <uc2:outside_Header ID="outside" runat="server" />
        <asp:Label runat="server" Text="Convert to email address login" CssClass="pageTitle"/>
        <asp:Label runat="server" Text="You will need to confirm your email address before logging back in" CssClass="pageDes" />
        <asp:Panel runat="server" >
            <asp:Label runat="server" ID="lblEmailAddress" CssClass="inputLabel">
                <asp:Label runat="server" Text="Email Address" />
                <asp:Label runat="server" Text="The email address to use with this account" CssClass="inputDes" />
            </asp:Label>
            <asp:TextBox ID="txtEmail1" MaxLength="256" Columns="60" runat="server" CssClass="inputBox"/>
            <asp:RequiredFieldValidator ID="rfvEmail" CssClass="error_message_small" Display="Dynamic" runat="server"
                ErrorMessage="Required field " ControlToValidate="txtEmail1"/>
            <asp:RegularExpressionValidator ID="regEmail" CssClass="error_message_small" Display="Dynamic" runat="server"
                ControlToValidate="txtEmail1" ErrorMessage="You must enter a valid email address "
                ValidationExpression="\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*" />
        </asp:Panel>
        <asp:Panel runat="server">
            <asp:Label runat="server" ID="lblEmailAddress2" CssClass="inputLabel">
                <asp:Label runat="server" Text="Confirm Email" />
                <asp:Label runat="server" Text="Email addresses must match" CssClass="inputDes" />
            </asp:Label>
            <asp:TextBox ID="txtEmail2" MaxLength="256" Columns="60" runat="server" CssClass="inputBox"/>
            <asp:CompareValidator ID="cvEmail2" CssClass="error_message_small" Display="Dynamic" runat="server"
                ErrorMessage="Emails do not match " Type="String" ControlToValidate="txtEmail1"
                ControlToCompare="txtEmail2" />
        </asp:Panel>
        <asp:Button ID="btnSubmit" runat="server" Text="Submit" onclick="btnSubmit_Click" style="margin-left:190px"
            OnClientClick="if (Page_ClientValidate() == true) {this.value = 'Processing...'; this.disabled = true; __doPostBack('btnSubmit','');}"/>
        <br />
        <asp:Label ID="lblSuccess" ForeColor="#008a5f" Visible="false" runat="server" 
            Text="Your login has been updated, an email has been sent to you with instructions on how to re-activate your account." />
        <asp:Label ID="lblError" ForeColor="Red" Text="Error" Visible="false" runat="server" />
    </div>
    <uc1:outside_footer ID="footer" runat="server" />
    </form>
</body>
</html>
