﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="login.aspx.cs" Inherits="SedonaWeb._Default" %>

<%@ Register Src="/Customizable/outside_footer.ascx" TagName="outside_footer" TagPrefix="uc1" %>
<%@ Register Src="/Customizable/outside_Header.ascx" TagName="outside_Header" TagPrefix="uc2" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <%= SedonaWeb.SWSCore.WebSettings.PageHeadInclude %>
  <link href="/css/global.css" rel="stylesheet" type="text/css" />
  <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
  <script type="text/javascript" src="/js/site.js"></script>
</head>
<body>
    <form id="form1" runat="server"  autocomplete="off">
    <div id="formContainer">
        <uc2:outside_Header ID="outside" runat="server" />
        <asp:Label runat="server" CssClass="pageTitle" Text="Welcome" />
        <asp:Label runat="server" CssClass="pageDes" Text="Please login with your information below, or create a new account." />
        <asp:Panel ID="Panel1" runat="server">
            <asp:Label ID="Label1" CssClass="inputLabel" runat="server">
                <asp:Label ID="lblLoginName" Text="Email Address" runat="server" />
            </asp:Label>
            <asp:TextBox ID="txtLoginName" MaxLength="256" Columns="60" runat="server" CssClass="inputBox" autocomplet="off" />
            <asp:RequiredFieldValidator ID="rfvLoginName" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ErrorMessage="Required field " ControlToValidate="txtLoginName" />
            <asp:RegularExpressionValidator ID="regLoginName" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ControlToValidate="txtLoginName" ErrorMessage="Not a valid email address"
                    ValidationExpression="\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*" />
        </asp:Panel>
        <asp:Panel ID="Panel2" runat="server">
            <asp:Label ID="Label2" CssClass="inputLabel" runat="server">
                <asp:Label ID="Label3" runat="server" Text="Password" />
            </asp:Label>
            <asp:TextBox ID="txtPassword" MaxLength="15" Columns="15" TextMode="Password" runat="server" autocomplet="off" CssClass="inputBox"/>
            <asp:RequiredFieldValidator ID="rfvPassword" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ErrorMessage="Required field " ControlToValidate="txtPassword" />
        </asp:Panel>
        <asp:Panel ID="Panel3" runat="server">
            <asp:Button ID="btnLogin" runat="server" Text="Login" OnClick="btnLogin_Click" style="margin-left:190px"/>
            <asp:Label ID="lblLoginFailed" runat="server" ForeColor="Red" Visible="false" Text="Incorrect Email/Password combination. Please try again." />
        </asp:Panel>
        <asp:Panel ID="Panel4" runat="server">
            <asp:HyperLink ID="hlNewAccount" runat="server" NavigateUrl="~/NewUser.aspx" Text="Setup New Account" />
            <asp:HyperLink ID="hlForgotPass" runat="server" NavigateUrl="~/ForgotPassword.aspx" Text="Forgot Password" style="margin-left:150px" />
            <asp:HyperLink ID="hlConvertAccount" runat="server" NavigateUrl="~/ConvertAccount.aspx" Text="Convert Account" style="margin-left:150px" />
        </asp:Panel>
        <asp:Label CssClass="user_message_label" ID="lblMessage" Visible="false" runat="server" />
        
        <noscript style="width: 100%; color: #FF0000; text-align: center;">
            Javascript not enabled, and this site needs javascript enabled to work properly.
            Please enable Javascript and refresh the page before continuing.
        </noscript>
        <div id="footer-container">
          <uc1:outside_footer ID="footer" runat="server" />
        </div>
    </div>
    </form>
    <script type="text/javascript">
      $(function () {
        var jqLogin = $("#txtLoginName");
        var jqToFocus = jqLogin.val().length > 0 ? $("#txtPassword") : jqLogin;
        jqToFocus.focus();
      });
    </script>
</body>
</html>