﻿if (typeof sw === "undefined") sw = {};

sw.initVersion = function() {
    var jqContainer = $("#footer-container");
    if (jqContainer.length == 0) return;
    jqContainer.hover(function (event) {
        var jqThis = $(this);
        $.get("/anonymous/getversion", function(data) {
            if (!data) return;
            jqThis.attr("title", data);
            // Only do it once.
            jqThis.unbind(event);
        });
    });
};

sw.initUserGrid = function() {
    var jqLinks = $("#users-div a.activate-link");
    if (jqLinks.length == 0) return;
    jqLinks.click(function() {
        var jqLink = $(this);
        var isActive = jqLink.html() == sw.deactivateLabel;
        var accountId = jqLink.attr("data-account-id");
        $.ajax({
            url: sw.setInactiveUrl,
            type: "POST",
            dataType: "json",
            data: JSON.stringify({ "accountId": accountId, "inactive": isActive }),
            contentType: "application/json; charset=utf-8",
            success: function (result) {
                console.info(result);
                if (result) {
                    jqLink.html(isActive ? sw.activateLabel : sw.deactivateLabel);
                    $(".active-label", jqLink.parent().parent()).html(isActive ? sw.inactiveLabel : sw.activeLabel);
                    return;
                }
            }
        });
    });
};

$(function () {
    sw.initVersion();
    sw.initUserGrid();
});