﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="EmailAuthentication.aspx.cs" Inherits="SedonaWeb.EmailAuthentication" %>

<%@ Register Src="/Customizable/outside_Header.ascx" TagName="outside_Header" TagPrefix="uc2" %>
<%@ Register Src="/Customizable/outside_footer.ascx" TagName="outside_footer" TagPrefix="uc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <%= SedonaWeb.SWSCore.WebSettings.PageHeadInclude %>
    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <link href="/css/global.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
        <div id="formContainer">
            <uc2:outside_Header ID="outside" runat="server" />
            <asp:Panel ID="SuccessPanel" Visible="false" runat="server">
                <asp:Label CssClass="pageTitle" runat="server" Text="Email Authentication Confirmation." />
                <asp:Label CssClass="pageDes" runat="server" Text="Please check your email for authentication information." />
            </asp:Panel>
            <asp:Panel ID="EntryPanel" runat="server">
                <asp:Label CssClass="pageTitle" runat="server" Text="Email Authentication Information" />
                <asp:Label CssClass="pageDes" runat="server" Text="Enter your customer number and email address." />
                <asp:Label ID="txtError" Visible="false" CssClass="error_message_small" runat="server" />
                <asp:Panel ID="PanelCustNum" runat="server">
                    <asp:Label ID="LabelCustNum" CssClass="inputLabel" runat="server">
                        <asp:Label ID="LabelCustNum2" runat="server" Text="Customer Number" />
                    </asp:Label>
                    <asp:TextBox ID="txtCustNum" Columns="15" MaxLength="15" runat="server" CssClass="inputBox" />
                    <asp:RequiredFieldValidator ID="rfvCustNum" CssClass="error_message_small" Display="Dynamic" runat="server"
                        ErrorMessage="Required field" ControlToValidate="txtCustNum" />
                </asp:Panel>
                <br />
                <asp:Panel ID="PanelEmail" runat="server">
                    <asp:Label ID="LabelEmail" CssClass="inputLabel" runat="server">
                        <asp:Label ID="LabelEmail2" runat="server" Text="Email" />
                    </asp:Label>
                    <asp:TextBox ID="txtEmail" Columns="50" MaxLength="50" runat="server" CssClass="inputBox" CausesValidation="true" />
                    <asp:RequiredFieldValidator ID="rfvEmail" CssClass="error_message_small" Display="Dynamic" runat="server"
                        ErrorMessage="Required field" ControlToValidate="txtEmail" />
                    <asp:CustomValidator ID="cvEmail" ControlToValidate="txtEmail" CssClass="error_message_small" Display="Dynamic"
                        ErrorMessage="Invalid format!" OnServerValidate="ValidateEmail" runat="server" />
                </asp:Panel>
                <br />
                <asp:Panel ID="PanelSubmit" runat="server">
                    <asp:Label ID="LabelSubmit" CssClass="inputLabel" runat="server">
                        <asp:Label ID="LabelSubmit2" CssClass="inputLabel" runat="server" />
                    </asp:Label>
                    <asp:Button ID="btnSubmit" runat="server" Text="Submit" OnClick="Submit" UseSubmitBehavior="false"
                        OnClientClick="{ btnSubmit.Enabled = false; btnSubmit.value = 'Processing...'; __doPostBack('btnSubmit',''); }" />
                </asp:Panel>
            </asp:Panel>
            <uc1:outside_footer ID="footer" runat="server" />
        </div>
    </form>

    <script type="text/javascript">
        var c = document.getElementById("txtCustNum");
        c.addEventListener("blur", validateRequired)
        var e = document.getElementById("txtEmail");
        e.addEventListener("blur", validateRequired)

        function validateRequired() {
            var custNum = c.value;
            var email = e.value;
            custNum = custNum.trim();
            email = email.trim();

            if (custNum.length > 0 && email.length > 0) {
                x = document.getElementById("txtError");
                x.hidden = true;
            }
        }
    </script>

</body>
</html>
