﻿<%@ Page Language="C#" MasterPageFile="~/inner.Master" AutoEventWireup="True"
    CodeBehind="default.aspx.cs" Inherits="SedonaWeb.payment_methods._default" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cphHead" runat="server">
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cphContent" runat="server">
    <asp:UpdatePanel ID="upPnl" runat="server">

        <ContentTemplate>
            <asp:Panel ID="pnlPayForms" runat="server">
                <div id="grid_headerCC">
                    Credit Cards
                </div>
                <br />
                <telerik:RadGrid ID="RadCreditCard" runat="server" OnNeedDataSource="RadCreditCard_NeedDataSource"
                    AutoGenerateColumns="false" OnItemCommand="RadCreditCardCommand" OnDataBound="_HandleCCDataBound">
                    <MasterTableView DataKeyNames="Card_Id">
                        <Columns>
                            <telerik:GridTemplateColumn HeaderText="Card Type" UniqueName="Card_Type">
                                <ItemTemplate>
                                    <asp:Label ID="lblCardType" runat="server" Text='<%# CCType(DataBinder.Eval(Container.DataItem, "Card_Type").ToString())%>' />
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="Last Four Digits" UniqueName="Card_Number">
                                <ItemTemplate>
                                    ...<%# DataBinder.Eval(Container.DataItem, "Last_Four")%>
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="Expiration Date" UniqueName="Expire_Date">
                                <ItemTemplate>
                                    <%# DataBinder.Eval(Container.DataItem, "Expiration_Month")%>
                                    /
                                    <%# DataBinder.Eval(Container.DataItem, "Expiration_Year")%>
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="Auto Pay" DataField="UsedForAutoProcess"
                                UniqueName="UsedForAutoProcess">
                                <ItemTemplate>
                                    <asp:LinkButton ID="btnToggleAuto" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "UsedForAutoProcess") %>'
                                        CommandArgument="auto" CommandName="RadCreditCardCommand" />
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridButtonColumn Text="Edit" CommandArgument="edit" /> 
                            <telerik:GridTemplateColumn UniqueName="CCDelete">
                                <ItemTemplate>
                                    <asp:LinkButton ID="btnCCDelete" CommandArgument="delete" OnClientClick="return confirm('Do you wish to delete this payment method? WARNING: This action cannot be undone!');"
                                        runat="server" Text="Delete" />
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                        </Columns>
                        <NoRecordsTemplate>
                            <div style="text-align: center">
                                No credit cards on file.
                            </div>
                        </NoRecordsTemplate>
                    </MasterTableView>
                </telerik:RadGrid>
                <br />
                <br />
                <br />
                <div id="grid_headerBank">
                    Bank Accounts</div>
                <br />
                <telerik:RadGrid ID="RadBankAccounts" runat="server" OnNeedDataSource="RadBankAccount_NeedDataSource"
                    AutoGenerateColumns="false" OnItemCommand="RadBankCommand" OnDataBound="_HandleBanksDataBound">
                    <MasterTableView DataKeyNames="Bank_Code,Bank_Id">
                        <Columns>
                            <telerik:GridBoundColumn DataField="Bank_Description" HeaderText="Bank" UniqueName="Bank_Description" />
                            <telerik:GridTemplateColumn HeaderText="Last Four Digits" UniqueName="Card_Number">
                                <ItemTemplate>
                                    ...<%# DataBinder.Eval(Container.DataItem, "Last_Four")%>
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="Account Type" UniqueName="Account_Type">
                                <ItemTemplate>
                                    <asp:Label ID="lblCardType" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "Checking_Or_Savings").ToString()=="C"?"Checking":"Savings"%>' />
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridBoundColumn DataField="Account_Name" HeaderText="Account Name" UniqueName="Account_Name" />
                            <telerik:GridTemplateColumn HeaderText="Auto Pay" DataField="UsedForAutoProcess"
                                UniqueName="UsedForAutoProcess">
                                <ItemTemplate>
                                    <asp:LinkButton ID="btnToggleAuto" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "UsedForAutoProcess") %>'
                                        CommandArgument="auto" CommandName="RadBankCommand" />
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridButtonColumn Text="Edit" CommandArgument="edit" />
                            <telerik:GridTemplateColumn UniqueName="BankDelete">
                                <ItemTemplate>
                                    <asp:LinkButton ID="btnBankDelete" CommandArgument="delete" OnClientClick="return confirm('Do you wish to delete this payment method? WARNING: This action cannot be undone!');"
                                        runat="server" Text="Delete" />
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                        </Columns>
                        <NoRecordsTemplate>
                            <div style="text-align: center">
                                No bank accounts on file.
                            </div>
                        </NoRecordsTemplate>
                    </MasterTableView>
                </telerik:RadGrid>
                <asp:Label ID="lblPayFormsMsg" runat="server" CssClass="error_message" Text="" />
            </asp:Panel>

           <asp:Panel ID="pnlAddCC" runat="server" Visible="false">
                <div id="formContainer">
                    <asp:Label runat="server" CssClass="pageTitle" Text="Add a New Credit Card" />
                    <asp:Label runat="server" CssClass="pageDes" Text="Fill in the information below to add a new credit card to your account." />

                    <asp:Panel runat="server" ID="PendingInvoicedTransactions" Visible="False">
                      <span class="inputLabel">
                        <span class="inputDes">Check to use this credit card for pending, invoiced transactions</span>
                      </span>
                      <asp:CheckBox ID="PendingCheckbox" Checked="True" runat="server" ForeColor="Red" Text="Use for <b>${0}</b> in pending credit card transactions." CssClass="inputBox" style="border:#FFFFFF"/>
                    </asp:Panel>
                    <asp:Panel ID="AutoBill" runat="server">
                        <asp:Label runat="server" CssClass="inputLabel">
                            <asp:Label runat="server" Text="Check to use this credit card for all future recurring invoices" CssClass="inputDes"/>
                        </asp:Label>
                        <asp:CheckBox ID="ckEFTCredit" Checked="True" runat="server" CssClass="inputBox" Text="Use this for auto bill payment" style="border:#FFFFFF" /> <%--AutoPostBack="True" OnCheckedChanged="ckEFTCredit_CheckedChanged"/>--%>
                    </asp:Panel>                 
                    <asp:Panel ID="AddCCAutoHoldDayPanel" runat="server" >
                        <asp:Label runat="server" CssClass="inputLabel" >
                            <asp:Label runat="server" Text="Auto Hold Day" />
                            <asp:Label runat="server" CssClass="inputDes" Text="Select the day of the month to charge your credit card" />
                        </asp:Label>
                        <asp:DropDownList runat="server" CssClass="inputBox" ID="ddlAddCreditAutoDay" />
                    </asp:Panel>
                    <br />

                    <asp:Panel ID="AddCCButtons" runat="server">
                        <asp:Button id="btnForteCC" runat="server" 
                            OnClientClick="return myFunc();" 
                            api_access_id=""
                            method="token"
                            version_number="2.0"
                            utc_time=""
                            signature=""
                            location_id=""
                            allowed_methods="visa,mast,disc,amex"
                            billing_name=""
                            billing_name_attr="edit, required"
                            billing_company_name=""
                            billing_company_name_attr="hide"
                            billing_street_line1=""
                            billing_street_line1_attr="edit"
                            billing_street_line2=""
                            billing_street_line2_attr="edit"
                            billing_locality=""
                            billing_locality_attr="edit"
                            billing_region=""
                            billing_region_attr="edit"
                            billing_postal_code=""
                            billing_postal_code_attr="edit"
                            billing_phone_number=""
                            billing_phone_number_attr="edit"
                            billing_email_address=""
                            billing_email_address_attr="edit"
                            save_token ="true"
                            callback="AddCCcallback"
                            Text="Add Card" CausesValidation="False" EnableViewState="False" UseSubmitBehavior="False" style="margin-left:190px">
	                    </asp:Button>
                        <asp:Button ID="btnCancelCredit" runat="server" Text="Cancel" OnClick="btnCancel_Click" CausesValidation="false" />
                    </asp:Panel>

                </div>
            </asp:Panel>

            <asp:Panel ID="pnlAddBank" runat="server" Visible="false" OnLoad="pnlAddBank_Load">
                <div id="formContainerAddBank">
                    <asp:Label runat="server" CssClass="pageTitle" Text="Add a New Bank Account" />
                    <asp:Label runat="server" CssClass="pageDes" Text="Fill in the information below to add a new bank account to your account." />

                    <asp:Panel ID="BankAutoCheck" runat="server">
                        <asp:Label runat="server" CssClass="inputLabel">
                            <asp:Label runat="server" Text="Check to use this bank for all future recurring invoices" CssClass="inputDes"/>
                        </asp:Label>
                        <asp:CheckBox ID="ckEFTBank" runat="server" Text="Use this for auto bill payment" CssClass="inputBox" style="border:#FFFFFF" /> <%-- AutoPostBack="True" OnCheckedChanged="ckEFTBank_CheckedChanged"/>--%>
                    </asp:Panel>
                    <asp:Panel ID="AddBankAutoHoldDayPanel" runat="server">
                        <asp:Label ID="lblAutoDayAddBank"  runat="server" CssClass="inputLabel">
                            <asp:Label runat="server" Text="Auto Hold Day" />
                            <asp:Label runat="server" Text="Select the day of the month to charge your bank account" CssClass="inputDes" />
                        </asp:Label>
                        <asp:DropDownList runat="server" ID="ddlAddBankAutoDay" CssClass="inputBox"/>
                    </asp:Panel>

                    <asp:Panel ID="AddBankButtons" runat="server">
                        <asp:Button id="btnForteBank" runat="server" 
                            OnClientClick="return myFunc();" 
                            api_access_id=""
                            method="token"
                            version_number="2.0"
                            utc_time=""
                            signature=""
                            location_id=""
                            allowed_methods="echeck"
                            billing_name=""
                            billing_name_attr="edit, required"
                            billing_company_name=""
                            billing_company_name_attr="hide"
                            billing_street_line1=""
                            billing_street_line1_attr="edit"
                            billing_street_line2=""
                            billing_street_line2_attr="edit"
                            billing_locality=""
                            billing_locality_attr="edit"
                            billing_region=""
                            billing_region_attr="edit"
                            billing_postal_code=""
                            billing_postal_code_attr="edit"
                            billing_phone_number=""
                            billing_phone_number_attr="edit"
                            billing_email_address=""
                            billing_email_address_attr="edit"
                            save_token ="true"
                            callback="AddBankCallback"
                            Text="Add Bank" CausesValidation="False" EnableViewState="False" UseSubmitBehavior="False" style="margin-left:190px">
	                    </asp:Button>
                        <asp:Button ID="btnCancelBank" runat="server" CausesValidation="false" OnClick="btnCancel_Click" Text="Cancel" />
                    </asp:Panel>

                </div>
            </asp:Panel>

            <asp:Panel ID="pnlEditCC" runat="server" Visible="false" OnLoad="pnlEditCC_Load">
                <div id="formContainerEditCC">
                    <asp:Label  runat="server" CssClass="pageTitle" Text="Edit a Credit Card" />
                    <asp:Label  runat="server" CssClass="pageDes" Text="Edit the available information for this credit card." />
                    <asp:Panel ID="EditCreditType" runat="server">
                        <asp:Label runat="server" CssClass="inputLabel">
                            <asp:Label runat="server" Text="Card Type" />
                        </asp:Label>
                        <asp:Label ID="lblCardType" runat="server" Text="" CssClass="inputBox" style="border:#FFFFFF"/>
                    </asp:Panel>
                    <asp:Panel ID="LastFour" runat="server">
                        <asp:Label runat="server" CssClass="inputLabel">
                            <asp:Label runat="server" Text="Card Number" />
                            <asp:Label runat="server" Text="Last four digits of card" CssClass="inputDes" />
                        </asp:Label>
                        <asp:Label ID="lblCardLastFour" runat="server" CssClass="inputBox" style="border:#FFFFFF"/>
                    </asp:Panel>
                    <asp:Panel ID="EditCCName" runat="server">
                        <asp:Label runat="server" CssClass="inputLabel">
                            <asp:Label runat="server" Text="Name on Card" />
                            <asp:Label runat="server" Text="Full name on card" CssClass="inputDes" />
                        </asp:Label>
                        <asp:TextBox ID="txtEditCCNameOnCard" runat="server" CssClass="inputBox" Enabled="false"/>
                        <asp:RequiredFieldValidator ID="rfvEditCCNameOnCard" runat="server" ControlToValidate="txtEditCCNameOnCard"
                                ErrorMessage="Name on the card is required" CssClass="error_message_small" />
                    </asp:Panel>
                    <asp:Panel ID="EditCCExp" runat="server">
                        <asp:Label runat="server" CssClass="inputLabel">
                            <asp:Label runat="server" Text="Expiration Date" />
                            <asp:Label runat="server" Text="Expiration date on the card" CssClass="inputDes" />
                        </asp:Label>
                        <asp:DropDownList ID="ddlEditCCExpireMonth" runat="server" CssClass="inputBox" Enabled="false"/>
                        <asp:Label runat="server" Text=" /" CssClass="inputBox" style="border:#FFFFFF" />
                        <asp:DropDownList ID="ddlEditCCExpireYear" runat="server" CssClass="inputBox" Enabled="false"/>
                    </asp:Panel>
                    <asp:Panel ID="EditCCAddress" runat="server">
                        <asp:Label runat="server" CssClass="inputLabel">
                            <asp:Label runat="server" Text="Billing Street Address" />
                            <span class="inputDes">Ex: 123 Washington Street</span>
                        </asp:Label>
                        <asp:TextBox ID="txtEditCCBillingAddress" runat="server" CssClass="inputBox"  Enabled="false"/>
                        <asp:RequiredFieldValidator ID="revEditCCBillingAddress" runat="server" ControlToValidate="txtEditCCBillingAddress"
                                ErrorMessage="Billing address is required" CssClass="error_message_small" />
                    </asp:Panel>
                    <asp:Panel ID="EditCCZip" runat="server">
                        <asp:Label runat="server" CssClass="inputLabel">
                            <asp:Label runat="server" Text="Postal Code" />
                            <asp:Label runat="server" Text="" CssClass="inputDes" />
                        </asp:Label>
                        <asp:TextBox ID="txtEditCCPostalCode" runat="server" MaxLength="5" CssClass="inputBox"  Enabled="false"/>
                        <asp:RegularExpressionValidator ID="revEditCCPostalCode" runat="server" ControlToValidate="txtEditCCPostalCode" CssClass="error_message_small"
                            Display="Dynamic" ErrorMessage="Not a valid postal code" ValidationExpression="(^\d{5}(-\d{4})?$)|(^[AaBbCcEeGgHhJjKkLlMmNnPpRrSsTtVvXxYy]{1}\d{1}[A-Za-z]{1} *\d{1}[A-Za-z]{1}\d{1}$)" />
                        <asp:RequiredFieldValidator ID="rfvEditCCPostalCode" runat="server" ControlToValidate="txtEditCCPostalCode" CssClass="error_message_small" 
                            Display="Dynamic" ErrorMessage="Postal code is required" />
                    </asp:Panel>

                    <asp:Panel ID="EditCCAutoPay" runat="server">
                        <asp:Label runat="server" CssClass="inputLabel">
                            <asp:Label runat="server" Text="Check to use this credit card for all future recurring invoices" />
                        </asp:Label>
                        <asp:CheckBox ID="ckEditCCBillPay" runat="server" Text="Use this for auto bill payment" CssClass="inputBox" style="border:#FFFFFF" AutoPostBack="True" OnCheckedChanged="ckEditCCBillPay_CheckedChanged" /></asp:Panel>
                    <asp:Panel ID="EditCCAutoHoldDayPanel" runat="server">
                        <asp:Label runat="server" CssClass="inputLabel">
                            <asp:Label runat="server" Text="Auto Hold Day" />
                            <asp:Label runat="server" Text="Select the day of the month to charge your credit card account" CssClass="inputDes" />
                        </asp:Label>
                        <asp:DropDownList ID="ddlEditCreditAutoDay" runat="server" CssClass="inputBox" />
                    </asp:Panel>
                    <asp:Panel ID="EditCCButtons" runat="server">
                        <asp:Button ID="btnEditCCSubmit" runat="server" OnClientClick="if (Page_ClientValidate() == true) {this.value = 'Processing...'; this.disabled = true;}" 
                            OnCommand="btnEditCCSubmit_Click" Text="Submit" UseSubmitBehavior="false" style="margin-left:190px" />
                        <asp:Button ID="btnEditCCCancel" runat="server" CausesValidation="false" OnClick="btnCancel_Click" Text="Cancel" />
                    </asp:Panel>
                    <asp:Label ID="lblEditCCMsg" runat="server" ForeColor="Red" Text="" />
                </div>
            </asp:Panel>

            <asp:Panel ID="pnlEditBank" runat="server" Visible="false" OnLoad="pnlEditBank_Load">
                <div id="formContainerEditBank">
                    <asp:Label runat="server" CssClass="pageTitle" Text="Edit a Bank Account" />
                    <asp:Label runat="server" CssClass="pageDes" Text="Change the available information for this bank account." />
                    <asp:Panel ID="EditBankRouting" runat="server">
                        <asp:Label runat="server" CssClass="inputLabel">
                            <asp:Label ID="EditRoutingNumberLabel" runat="server" Text="Routing Number" />
                        </asp:Label>
                        <asp:Label ID="lblRoutingNumber" runat="server" CssClass="inputBox" style="border:#FFFFFF"/>
                    </asp:Panel>
                    <asp:Panel ID="EditBankAcctNum" runat="server">
                        <asp:Label runat="server" CssClass="inputLabel">
                            <asp:Label runat="server" Text="Account Number" />
                        </asp:Label>
                        <asp:Label ID="lblAccountNumber" runat="server" CssClass="inputBox" style="border:#FFFFFF" />
                    </asp:Panel>
                    <asp:Panel ID="EditBankName" runat="server">
                        <asp:Label runat="server" CssClass="inputLabel">
                            <asp:Label runat="server" Text="Name of Bank" />
                        </asp:Label>
                        <asp:Label ID="lblBankNameEdit" runat="server" CssClass="inputBox" style="border:#FFFFFF" />
                    </asp:Panel>
                    <asp:Panel ID="EditBankAcctName" runat="server">
                        <asp:Label  runat="server" CssClass="inputLabel">
                            <asp:Label runat="server" Text="Name on Account" />
                            <asp:Label runat="server" Text="Full name on the account" CssClass="inputDes" />
                        </asp:Label>
                        <asp:TextBox ID="txtNameonAccountEdit" runat="server" CssClass="inputBox" Enabled="false" />
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="txtNameonAccountEdit"
                                ErrorMessage="Please enter the name on the account" CssClass="error_message_small" />
                    </asp:Panel>
                    <asp:Panel ID="EditBankType" runat="server">
                        <asp:Label runat="server" CssClass="inputLabel" />
                         <asp:RadioButton ID="rbCheckingEdit" runat="server" Text="Checking Account" GroupName="AccountType" Checked="true" Enabled="false" /> 
                         <asp:RadioButton ID="rbSavingsEdit" runat="server" Text="Savings Account" GroupName="AccountType" Enabled="false" />
                    </asp:Panel>
                    <asp:Panel ID="EditBankAutoPay" runat="server">
                        <asp:Label runat="server" CssClass="inputLabel">
                            <asp:Label runat="server" Text="" />
                            <asp:Label runat="server" Text="Check to use this bank for all future recurring invoices" CssClass="inputDes" />
                        </asp:Label>
                        <asp:CheckBox ID="ckEFTBankEdit" runat="server" Text="Use this for auto bill payment" AutoPostBack="True" OnCheckedChanged="ckEFTBankEdit_CheckedChanged" /></asp:Panel>
                    <asp:Panel ID="EditBankAutoHoldDayPanel" runat="server">
                        <asp:Label ID="lblAutoDayEditBank" runat="server" CssClass="inputLabel">
                            <asp:Label runat="server" Text="Auto Hold Day" />
                            <asp:Label runat="server" Text="Select the day of the month to charge your bank account" CssClass="inputDes" />
                        </asp:Label>
                        <asp:DropDownList runat="server" ID="ddlEditBankAutoDay" CssClass="inputBox"/>
                    </asp:Panel>
                    <asp:Panel ID="EditBankButtons" runat="server">
                        <asp:Button ID="btnSubmitBankEdit" runat="server" Text="Submit" OnCommand="btnSubmitBankEdit_Click" UseSubmitBehavior="false" 
                                OnClientClick="if (Page_ClientValidate() == true) {this.value = 'Processing...'; this.disabled = true;}" style="margin-left:190px" />
                        <asp:Button ID="btnCancelBankEdit" runat="server" Text="Cancel" OnClick="btnCancel_Click" CausesValidation="false" />
                    </asp:Panel>
                    <asp:Label ID="lblBankMsgEdit" runat="server" ForeColor="Red" />
                </div>
            </asp:Panel>
        <asp:HiddenField ID="hfMessage" runat="server" ClientIDMode="Static" />
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>

<asp:Content ID="Content3" ContentPlaceHolderID="cphScripts" runat="server">
    <script type="text/javascript" src="../Scripts/jquery-1.11.1.js"></script>
    <script type="text/javascript">

        function AustalianRoutingNumberConfirm(message) {
            debugger
            var confirm_value = document.createElement("INPUT");
            confirm_value.type = "hidden";
            confirm_value.name = "confirm_value";
            if (confirm(message)) {
                confirm_value.value = "Yes";
            } else {
                confirm_value.value = "No";
            }
            document.forms[0].appendChild(confirm_value);
            if (confirm_value.value != "Yes")
<%--                document.getElementById('<%= btnSubmitBank.ClientID %>').click();
            else--%>
                document.getElementById('<%= btnCancelBank.ClientID %>').click();
        }

        function CheckHidden() {
            var text = document.getElementById('hfMessage')
            if (text.value != "") {
                alert(text.value);
                text.value = "";
            }
        }

        function AddCCcallback(e) {
            var response = JSON.parse(e.data);
            switch (response.event) {
                case 'begin':
                    //call to forte checkout is successful
                    break;
                case 'success':
                    {
                        //transaction successful 
                        alert('Card securely registered.');

                        var chkPending = document.getElementById('<%= PendingCheckbox.ClientID %>');
                        if (chkPending != null)
                            var useForPending = (chkPending.checked ? 'Y' : 'N');
                        else
                            useForPending = 'N';

                        var chkRecurring = document.getElementById('<%= ckEFTCredit.ClientID %>');
                        if (chkRecurring != null)
                            var useForRecurring = (chkRecurring.checked ? 'Y' : 'N');
                        else
                            useForRecurring = 'N';

                        var ddlChargeDay = document.getElementById('<%= ddlAddCreditAutoDay.ClientID %>');
                        if (ddlChargeDay != null)
                            var chargeDay = ddlChargeDay.value;
                        else
                            chargeDay = 1;

                        var cardInfo = response.paymethod_token + ',' + response.method_used + ',' + response.last_4 + ',' + response.expire_month + ',' + response.expire_year
                                     + ',' + useForPending + ',' + useForRecurring + ',' + chargeDay;
                        PageMethods.ProcessCard(cardInfo, '<%= AppUser.Customer_Number %>', '<%= AppUser.Account_Name %>');
                    }
                    break;
                case 'failure':
                    //handle failed transaction            
                    alert('sorry, transaction failed. failed reason is ' + response.response_description);
                    break;
                case 'abort':
                    break;
            }
        }

        function AddBankCallback(e) {
            var response = JSON.parse(e.data);
            switch (response.event) {
                case 'begin':
                    //call to forte checkout is successful
                    break;
                case 'success':
                    {
                        //transaction successful 
                        alert('Bank securely registered.');

                        var chkRecurring = document.getElementById('<%= ckEFTBank.ClientID %>');
                        if (chkRecurring != null)
                            var useForRecurring = (chkRecurring.checked ? 'Y' : 'N');
                        else
                            useForRecurring = 'N';

                        var ddlChargeDay = document.getElementById('<%= ddlAddBankAutoDay.ClientID %>');
                        if (ddlChargeDay != null)
                            var chargeDay = ddlChargeDay.value;
                        else
                            chargeDay = 1;

                        var bankInfo = response.paymethod_token + ',' + response.method_used + ',' + response.last_4
                                     + ',' + useForRecurring + ',' + chargeDay;
                        PageMethods.ProcessBank(bankInfo, '<%= AppUser.Customer_Number %>', '<%= AppUser.Account_Name %>');
                    }
                    break;
                case 'failure':
                    //handle failed transaction            
                    alert('sorry, transaction failed. failed reason is ' + response.response_description);
                    break;
                case 'abort':
                    break;
            }
        }

        function myFunc() {
            return false;
        }
    </script>

    <script runat="server">
        public string CCType(string type)
        {
            switch (type)
            {
                case "VISA":
                    return "Visa";
                case "MAST":
                    return "Mastercard";
                case "DISC":
                    return "Discover";
                case "AMER":
                case "AMEX":
                    return "American Express";
                case "DINE":
                    return "Diner's Club";
            }
            return "";
        }
    </script>
</asp:Content>
