﻿<%@ Page Language="C#" MasterPageFile="~/inner.Master" AutoEventWireup="true" CodeBehind="default.aspx.cs" Inherits="SedonaWeb.invoices._default" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Import Namespace="SedonaWeb.SWSCore" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cphHead" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cphContent" runat="server">

  <asp:Table CssClass="TableType1" ID="TopLinksTable" runat="server" Visible="true">
    <asp:TableRow>
      <asp:TableCell ColumnSpan="2" CssClass="TableCellAlignCenter">
        <asp:Label ID="radgrid_invoices_label" CssClass="LargeLabel" Text="Open Invoices" runat="server" />
      </asp:TableCell>
    </asp:TableRow>
  </asp:Table>

  <telerik:RadGrid ID="RadGridOpenInvoices" runat="server" AutoGenerateColumns="false" AllowSorting="true" Visible="true">
    <MasterTableView>
      <Columns>
        <telerik:GridTemplateColumn HeaderText="Select">
          <HeaderTemplate>
            <input id="check-all-checkbox" title="Select All" type="checkbox" />
          </HeaderTemplate>
          <ItemTemplate>
            <span class="invoice-checkbox-container">
              <asp:CheckBox runat="server" ID="InvoiceCheckbox" Visible="<%# !AppLogic.IsPendingPayment(Container.DataItem) %>" />
              <input type="hidden" class="invoice-number" value="<%# DataBinder.Eval(Container.DataItem, "Invoice_Number") %>"/>
            </span>
          </ItemTemplate>
        </telerik:GridTemplateColumn>
        <telerik:GridTemplateColumn UniqueName="Invoice_Number" DataField="Invoice_Number" SortExpression="Invoice_Number" HeaderText="Invoice #">
          <ItemTemplate>
            <asp:HyperLink ID='HyperLinkInvoiceDetail' NavigateUrl='<%# "/invoices/invoice.aspx?invoice=" + Uri.EscapeDataString(DataBinder.Eval(Container.DataItem, "Invoice_Number").ToString()) %>'
              runat='server' Text='<%# DataBinder.Eval(Container.DataItem, "Invoice_Number") %>' Visible='true' />
          </ItemTemplate>
        </telerik:GridTemplateColumn>
        <telerik:GridBoundColumn AllowSorting="true" DataField="Invoice_Date" DataType="System.DateTime" DataFormatString="{0:d}" HeaderText="Date" SortExpression="Invoice_Date" UniqueName="Invoice_Date" />
        <telerik:GridBoundColumn AllowSorting="true" DataField="Business_Name" HeaderText="Site" SortExpression="Business_Name" UniqueName="Business_Name" />
        <telerik:GridBoundColumn AllowSorting="true" DataField="Inv_Desc_Code" HeaderText="Description" SortExpression="Inv_Desc_Code" UniqueName="Inv_Desc_Code" />
        <telerik:GridBoundColumn AllowSorting="true" DataType="System.Decimal" DataField="Amount" DataFormatString="{0:$###,##0.00}" HeaderText="Amount" SortExpression="Amount" UniqueName="Amount" />
        <telerik:GridBoundColumn AllowSorting="true" DataType="System.Decimal" DataField="Net_Due" DataFormatString="{0:$###,##0.00}" HeaderText="Net Due" SortExpression="Net_Due" UniqueName="Net_Due" />
        <telerik:GridTemplateColumn>
          <ItemTemplate>
            <asp:HyperLink ID='HyperLinkInvoicePayment' NavigateUrl='<%# "~/Payment_Methods/payment.aspx?invoice=" + Uri.EscapeDataString(DataBinder.Eval(Container.DataItem, "Invoice_Number").ToString()) %>'
              runat='server' Text='<%# !AppLogic.IsPendingPayment(Container.DataItem)? "Pay it":"Payment Pending" %>'
              Visible='true' Enabled='<%# !AppLogic.IsPendingPayment(Container.DataItem) %>'
              Style='<%# !AppLogic.IsPendingPayment(Container.DataItem) ? "font-weight:bold;font-size:15px;color:#0D819A": "text-decoration:none;" %>'
              Target="_self" />
          </ItemTemplate>
        </telerik:GridTemplateColumn>
      </Columns>
    </MasterTableView>
  </telerik:RadGrid>

  <asp:Button ID="PaySelectedInvoicesButton" PostBackUrl="~/payment_methods/payment.aspx" runat="server" Text="Pay Selected" />

  <telerik:RadGrid ID="RadGridPaidInvoices" AutoGenerateColumns="false" AllowSorting="true" runat="server" Visible="false">
    <MasterTableView>
      <Columns>
        <telerik:GridTemplateColumn SortExpression="Invoice_Number" HeaderText="Invoice #">
          <ItemTemplate>
            <asp:HyperLink ID='HyperLinkInvoicePaid' NavigateUrl='<%# "./invoice.aspx?invoice=" + Uri.EscapeDataString(DataBinder.Eval(Container.DataItem, "Invoice_Number").ToString()) %>' runat='server' Text='<%# DataBinder.Eval(Container.DataItem, "Invoice_Number") %>' Visible='true' />
          </ItemTemplate>
        </telerik:GridTemplateColumn>
        <telerik:GridBoundColumn AllowSorting="true" DataField="Invoice_Date" DataType="System.DateTime" DataFormatString="{0:d}" HeaderText="Date" SortExpression="Invoice_Date" UniqueName="Invoice_Date" />
        <telerik:GridBoundColumn AllowSorting="true" DataField="Business_Name" HeaderText="Site" SortExpression="Business_Name" UniqueName="Business_Name" />
        <telerik:GridBoundColumn AllowSorting="true" DataField="Inv_Desc_Code" HeaderText="Description" SortExpression="Inv_Desc_Code" UniqueName="Inv_Desc_Code" />
        <telerik:GridBoundColumn AllowSorting="true" DataType="System.Decimal" DataField="Amount" DataFormatString="{0:$###,##0.00}" HeaderText="Amount" SortExpression="Amount" UniqueName="Amount" />
      </Columns>
    </MasterTableView>
  </telerik:RadGrid>

  <asp:HiddenField runat="server" ClientIDMode="Static" ID="SelectedInvoices" />

</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="cphScripts" runat="server">
  <script type="text/javascript">
    var sedona = {
      getNonPendingInvoiceCount: function() {
        return $(".invoice-checkbox-container > input[type=checkbox]").length;
      },

      getSelectedInvoiceCount: function() {
        return $(".invoice-checkbox-container > input[type=checkbox]:checked").length;
      },
      
      paySelectedButtonSelector: "input[value=Pay Selected]"
    };

    $(function () {
      // Disable buttons and checkboxes if all are pending.
      if (sedona.getNonPendingInvoiceCount() == 0) {
        $(sedona.paySelectedButtonSelector + ", #check-all-checkbox").attr("disabled", "disabled");
      }

      if (sedona.getSelectedInvoiceCount() == 0)
        $(sedona.paySelectedButtonSelector).attr("disabled", "disabled");
      else
        $(sedona.paySelectedButtonSelector).addClass("enabled-button");
      
      // IE 10 compatibility mode does not detect change until blur. 
      if ($.browser.msie) {
        $("input[type=checkbox]").click(function () {
          this.blur();
          this.focus();
        });
      }

      // Check all checkboxes.
      $("#check-all-checkbox").change(function () {
        var allChecked = this.checked;
        $(".invoice-checkbox-container > input[type=checkbox]").each(function (key, value) {
          value.checked = allChecked;
        });
      });

      $("#check-all-checkbox, .invoice-checkbox-container > input[type=checkbox]").change(function () {
        var jqButton = $(sedona.paySelectedButtonSelector);
        if (sedona.getSelectedInvoiceCount() == 0) {
          jqButton.attr("disabled", "disabled");
          jqButton.removeClass("enabled-button");
          return;
        }

        jqButton.removeAttr("disabled");
        jqButton.addClass("enabled-button");
      });

      // It puts the lotion on its skin.
      $("form").submit(function () {
        var values = "";
        $(".invoice-checkbox-container > input[type=checkbox]:checked").each(function (key, value) {
          values += $(".invoice-number", $(value).parent()).val() + "~";
        });

        $("#SelectedInvoices").val(values);
        return values.length > 1;
      });
    });
  </script>
</asp:Content>
