﻿<%@ Page Language="C#" MasterPageFile="~/inner.Master" AutoEventWireup="true" CodeBehind="change_password.aspx.cs" Inherits="SedonaWeb.home.change_password" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cphHead" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cphContent" runat="server">

<div id="formContainer">    
    <asp:Label runat="server" CssClass="pageTitle" Text="Change your Password" />
    <asp:Label runat="server" CssClass="pageDes" Text="Enter and confirm your new password to update it." />
    <asp:Panel runat="server">
        <asp:Label ID="lblPassword" runat="server" CssClass="inputLabel">
            <asp:Label runat="server" Text="New Password" />
            <asp:Label runat="server" CssClass="inputDes" Text="Must be 5 to 15 characters"/>
        </asp:Label>            
        <asp:TextBox CssClass="inputBox" ID="tbNewPassword" ClientIDMode="Static" MaxLength="15" runat="server" TextMode="Password" autocomplete="off" />
        <asp:RequiredFieldValidator ID="rfvPassword1" CssClass="error_message_small" Display="Dynamic" runat="server"
                                      ErrorMessage="Required field " ControlToValidate="tbNewPassword" />
          <asp:RegularExpressionValidator ID="revPassword1" CssClass="error_message_small" Display="Dynamic" runat="server"
                                          ControlToValidate="tbNewPassword" ErrorMessage="Password must be between 8 and 15 characters long."
                                          ValidationExpression=".{8,15}" />
          <asp:RegularExpressionValidator ID="revPassword2" CssClass="error_message_small" Display="Dynamic" runat="server"
                                          ControlToValidate="tbNewPassword" ErrorMessage="Must include at least 1 uppercase and 1 lowercase alphabet, 1 number and 1 special character."
                                          ValidationExpression="^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[$@$!%*?&#])[A-Za-z\d$@$!%*?&#]{8,15}" />
    </asp:Panel>
    <asp:Panel runat="server">
        <asp:Label ID="lblConfirmPass" runat="server" CssClass="inputLabel">
            <asp:Label runat="server" Text="Confirm Password" />
            <asp:Label runat="server" CssClass="inputDes" Text="Passwords must match"/>
        </asp:Label>
            <asp:TextBox CssClass="inputBox" ID="tbVerifyPassword" MaxLength="15" runat="server" TextMode="Password" autocomplete="off" />
            <asp:CompareValidator ID="cvVerifyPassword" CssClass="error_message_small" Display="Dynamic" runat="server"
                ErrorMessage="Passwords do not match " Type="String" ControlToValidate="tbNewPassword"
                ControlToCompare="tbVerifyPassword" />
    </asp:Panel>
    <asp:Button CausesValidation="true" Enabled="true" ID="bUpdate" OnCommand="bUpdate_Click" runat="server" Text="Update" style="margin-left:190px" />
    <asp:Label ID="lblSuccess" runat="server" Visible="false" CssClass="success_message" Text="Password Updated Successfully!" />
</div>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="cphScripts" runat="server">
  <script type="text/javascript">
    $(function() {
      $("#tbNewPassword").focus();
    });
  </script>
</asp:Content>
