﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ResetPassword.aspx.cs" Inherits="SedonaWeb.ResetPassword" %>
<%@ Register Src="/Customizable/outside_Header.ascx" TagName="outside_Header" TagPrefix="uc2" %>
<%@ Register Src="/Customizable/outside_footer.ascx" TagName="outside_footer" TagPrefix="uc1" %>


<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
  <head id="Head1" runat="server">
    <%= SedonaWeb.SWSCore.WebSettings.PageHeadInclude %>
    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.3.2/jquery.min.js"></script>
    <link href="/css/global.css" rel="stylesheet" type="text/css" />
  </head>
  <body>
    <form id="form1" runat="server">
      <div id="formContainer">
        <uc2:outside_Header ID="outside" runat="server" />  
        <asp:Label CssClass="pageTitle" runat="server" Text="Reset password" />
        <asp:Label ID="lblEmail" CssClass="pageDes" runat="server"/> 
        <asp:Panel ID="pnlNewPass" runat="server">
          <asp:Label ID="Label1" CssClass="inputLabel" runat="server">
            <asp:Label ID="Label2" runat="server" Text="New Password"/>
            <asp:Label ID="Label3" runat="server" Text="Between 5 and 15 characters" CssClass="inputDes" />
          </asp:Label>
          <asp:TextBox ID="txtPass1" Columns="15" MaxLength="15" TextMode="Password" runat="server" CssClass="inputBox" autocomplete="off" />
          <asp:RequiredFieldValidator ID="rfvPassword1" CssClass="error_message_small" Display="Dynamic" runat="server"
                                      ErrorMessage="Required field " ControlToValidate="txtPass1" />
          <asp:RegularExpressionValidator ID="revPassword1" CssClass="error_message_small" Display="Dynamic" runat="server"
                                          ControlToValidate="txtPass1" ErrorMessage="Password must be between 8 and 15 characters long."
                                          ValidationExpression=".{8,15}" />
          <asp:RegularExpressionValidator ID="revPassword2" CssClass="error_message_small" Display="Dynamic" runat="server"
                                          ControlToValidate="txtPass1" ErrorMessage="Must include at least 1 uppercase and 1 lowercase alphabet, 1 number and 1 special character."
                                          ValidationExpression="^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[$@$!%*?&#])[A-Za-z\d$@$!%*?&#]{8,15}" />
        </asp:Panel>
        <asp:Panel ID="pnlConfirmPass" runat="server">
          <asp:Label ID="Label4" CssClass="inputLabel" runat="server">
            <asp:Label ID="Label5" runat="server" Text="Confirm Password" />
            <asp:Label ID="Label6" CssClass="inputDes" runat="server" Text="Passwords must match." />
          </asp:Label>
          <asp:TextBox ID="txtPass2" Columns="15" MaxLength="15" TextMode="Password" runat="server" CssClass="inputBox" autocomplete="off" />
          <asp:CompareValidator ID="CompareValidator1" CssClass="error_message_small" Display="Dynamic" runat="server"
                                ErrorMessage="Passwords do not match " Type="String" ControlToValidate="txtPass1"
                                ControlToCompare="txtPass2" />
        </asp:Panel>
        <asp:Panel ID="Panel3" runat="server">
          <asp:Button ID="btnSubmit" runat="server" Text="Submit" OnClick="btnSubmit_Click" UseSubmitBehavior="false"  style="margin-left: 190px"
                      OnClientClick=" if (Page_ClientValidate() == true) {this.value = 'Processing...'; this.disabled = true; __doPostBack('btnSubmit', '');} " />
        </asp:Panel>
        <p>
          <asp:Label ID="lblError" runat="server" Text="We could not find your account number.  Please contact support for further assistance." Visible="false" ForeColor="Red" />
          <asp:HyperLink ID="hlLogin" runat="server" Text="Password changed successfully; click to login" NavigateUrl="~/login.aspx" Visible="false"/>
        </p>    
        <uc1:outside_footer ID="footer" runat="server" />
      </div>
    </form>
   
  </body>
</html>