﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="NewUser.aspx.cs"
    Inherits="SedonaWeb.NewUser" %>

<%@ Register Src="/Customizable/outside_Header.ascx" TagName="outside_Header" TagPrefix="uc2" %>
<%@ Register Src="/Customizable/outside_footer.ascx" TagName="outside_footer" TagPrefix="uc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <%= SedonaWeb.SWSCore.WebSettings.PageHeadInclude %>
    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.3.2/jquery.min.js"></script>
    <link href="/css/global.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
        <div id="formContainer">
            <uc2:outside_Header ID="outside" runat="server" />
            <asp:Panel ID="SuccessPanel" Visible="False" runat="server">
                <p style="color: #238961; font-weight: bold">
                    Thank you for creating an Account. 
                    An email has been sent to your email address with instructions on how to activate your Login. 
                    Check your junk/spam mail folders if you do not receive the email promptly.
                </p>
            </asp:Panel>
            <asp:Label ID="txtError" CssClass="error_message_small" runat="server" />
            <asp:Label CssClass="pageTitle" runat="server" Text="Create a new account" />
            <asp:Label CssClass="pageDes" runat="server" Text="Welcome to the Account Setup process.  Please fill in each required field below." />
            <asp:Panel runat="server">
                <asp:Label ID="CustomerNumber" CssClass="inputLabel" runat="server">
                    <asp:Label runat="server" Text="Customer Number*" />
                    <asp:Label CssClass="inputDes" runat="server" Text="Used to identify you" />
                </asp:Label><asp:TextBox runat="server" ID="txtCustNum" Columns="15" MaxLength="15" CssClass="inputBox" /> 
                <asp:RequiredFieldValidator ID="rfvCustNum" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ErrorMessage="Required field " ControlToValidate="txtCustNum" />           
            </asp:Panel>
            <asp:Panel ID="Panel2" runat="server">
                <asp:Label ID="FirstName" CssClass="inputLabel" runat="server">
                    <asp:Label ID="Label5" runat="server" Text="First Name*" />
                </asp:Label><asp:TextBox runat="server" ID="txtNameFirst" Columns="30" MaxLength="30" CssClass="inputBox"/>
                <asp:RequiredFieldValidator ID="rfvNameFirst" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ErrorMessage="Required field " ControlToValidate="txtNameFirst"/>
            </asp:Panel>
            <asp:Panel ID="Panel3" runat="server">
                <asp:Label ID="LastName" CssClass="inputLabel" runat="server">
                    <asp:Label ID="Label6" runat="server" Text="Last Name*" />
                </asp:Label><asp:TextBox runat="server" ID="txtNameLast" Columns="30" MaxLength="30" CssClass="inputBox"/>
                <asp:RequiredFieldValidator ID="rfvNameLast" CssClass="error_message_small" Display="Dynamic" runat="server"
                        ErrorMessage="Required field " ControlToValidate="txtNameLast" />
            </asp:Panel>
            <asp:Panel ID="Panel4" runat="server">
                <asp:Label ID="ZipCode" CssClass="inputLabel" runat="server">
                    <asp:Label ID="Label7" runat="server" Text="Billing Zip Code*" />
                    <asp:Label ID="Label8" CssClass="inputDes" runat="server" Text="Your billing zip" />    
                </asp:Label><asp:TextBox ID="txtBillZip" Columns="7" MaxLength="7" runat="server" CssClass="inputBox" />
                <asp:RequiredFieldValidator ID="rfvBillZip" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ErrorMessage="Required field " ControlToValidate="txtBillZip" />
                <asp:RegularExpressionValidator ID="revBillZip" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ControlToValidate="txtBillZip" ErrorMessage="Zip must be in 12345 format for US or A2A 2A2 for Canada"
                    ValidationExpression="(^\d{5}$)|(^[AaBbCcEeGgHhJjKkLlMmNnPpRrSsTtVvXxYy]{1}\d{1}[A-Za-z]{1} *\d{1}[A-Za-z]{1}\d{1}$)" />
            </asp:Panel>
            <asp:Panel ID="Panel5" runat="server">
                <asp:Label ID="Email1" CssClass="inputLabel" runat="server">
                    <asp:Label ID="Label9" runat="server" Text="Email Address*" />
                    <asp:Label ID="Label10" CssClass="inputDes" runat="server" Text="Used as username" />
                </asp:Label><asp:TextBox ID="txtEmail1" Columns="50" MaxLength="256" runat="server" CssClass="inputBox"/>
                <asp:RequiredFieldValidator ID="rfvEmail1" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ErrorMessage="Required field " ControlToValidate="txtEmail1" />
                <asp:RegularExpressionValidator ID="revEmail1" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ControlToValidate="txtEmail1" ErrorMessage="You must enter a valid email address "
                    ValidationExpression="\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*" />
            </asp:Panel>
            <asp:Panel ID="Panel6" runat="server">
                <asp:Label ID="Email2" CssClass="inputLabel" runat="server">
                    <asp:Label ID="Label11" runat="server" Text="Confirm Email*" />
                    <asp:Label ID="Label12"  CssClass="inputDes" runat="server" Text="Emails must match" />
                </asp:Label><asp:TextBox ID="txtEmail2" Columns="50" MaxLength="256" runat="server" CssClass="inputBox"/>
                <asp:RequiredFieldValidator ID="rfvEmail2" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ErrorMessage="Required field " ControlToValidate="txtEmail2" />
                <asp:CompareValidator ID="cvEmail2" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ErrorMessage="Emails do not match " Type="String" ControlToValidate="txtEmail2"
                    ControlToCompare="txtEmail1" />
            </asp:Panel>
            <asp:Panel ID="Panel7" runat="server">
                <asp:Label ID="Password1" CssClass="inputLabel" runat="server">
                    <asp:Label ID="Label13" runat="server" Text="Password*" />
                    <asp:Label ID="Label14" CssClass="inputDes" runat="server" Text="Between 8 and 15 characters long." />
                </asp:Label>
                <asp:TextBox ID="txtPassword1" Columns="13" MaxLength="15" autocomplete="off" TextMode="Password" runat="server" CssClass="inputBox"/>
                <asp:RequiredFieldValidator ID="rfvPassword1" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ErrorMessage="Required field " ControlToValidate="txtPassword1" />
                <asp:RegularExpressionValidator ID="revPassword1" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ControlToValidate="txtPassword1" ErrorMessage="Password must be between 8 and 15 characters long."
                    ValidationExpression=".{8,15}" />
                <asp:RegularExpressionValidator ID="revPassword2" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ControlToValidate="txtPassword1" ErrorMessage="Must include at least 1 uppercase and 1 lowercase alphabet, 1 number and 1 special character."
                    ValidationExpression="^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[$@$!%*?&#])[A-Za-z\d$@$!%*?&#]{8,15}" />
            </asp:Panel>
            <asp:Panel ID="Panel8" runat="server">
                <asp:Label ID="Password2" CssClass="inputLabel" runat="server">
                    <asp:Label ID="Label15" runat="server" Text="Confirm Password*" />
                    <asp:Label ID="Label16" CssClass="inputDes" runat="server" Text="Passwords must match" />
                </asp:Label><asp:TextBox ID="txtPassword2" Columns="13" MaxLength="15" autocomplete="off" TextMode="Password" runat="server" CssClass="inputBox"/>
                <asp:CompareValidator ID="CompareValidator1" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ErrorMessage="Passwords do not match " Type="String" ControlToValidate="txtPassword1"
                    ControlToCompare="txtPassword2" />
            </asp:Panel>
            <asp:Panel ID="Panel9" runat="server">
                <asp:Label ID="Phone" CssClass="inputLabel" runat="server">
                    <asp:Label ID="Label17" runat="server" Text="Phone" />
                    <asp:Label ID="Label18" CssClass="inputDes" runat="server" Text="Ex: 248-123-4567" />
                </asp:Label><asp:TextBox ID="txtPhoneNum" Columns="13" MaxLength="13" runat="server" CssClass="inputBox" />
                <asp:RegularExpressionValidator ID="revPhoneNum" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ControlToValidate="txtPhoneNum" ErrorMessage="Enter valid format: (248)123-4567, 248-123-4567, 248 123 4567 or 248.123.4567" 
                    ValidationExpression="(\([2-9]\d{2}|[2-9]\d{2})[\)\- .]\d{3}[\- .]\d{4}" />
            </asp:Panel>
            <asp:Panel ID="Panel10" runat="server">
                <asp:Label ID="PhoneExt" CssClass="inputLabel" runat="server">
                    <asp:Label ID="Label19" runat="server" Text="Extension" />
                    <asp:Label ID="Label20" CssClass="inputDes" runat="server" Text="Valid numeric digits" />
                </asp:Label><asp:TextBox ID="txtPhoneExt" Columns="7" MaxLength="5" runat="server" CssClass="inputBox" />
                <asp:RegularExpressionValidator ID="revPhoneExt" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ControlToValidate="txtPhoneExt" ErrorMessage="Must be numeric " ValidationExpression="^([0-9]{0,5})$" />
            </asp:Panel>
            <asp:Panel ID="Panel11" runat="server">
                <asp:Label ID="MobilePhone" CssClass="inputLabel" runat="server">
                    <asp:Label ID="Label21" runat="server" Text="Mobile" />
                    <asp:Label ID="Label22" CssClass="inputDes" runat="server" Text="Your mobile number" />
                </asp:Label><asp:TextBox ID="txtPhoneNumMobile" Columns="13" MaxLength="13" runat="server" CssClass="inputBox" />
                <asp:RegularExpressionValidator ID="revPhoneNumMobile" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ControlToValidate="txtPhoneNumMobile" ErrorMessage="Enter valid format: (248)123-4567, 248-123-4567, 248 123 4567 or 248.123.4567"
                    ValidationExpression="(\([2-9]\d{2}|[2-9]\d{2})[\)\- .]\d{3}[\- .]\d{4}" />
            </asp:Panel>
            <asp:Panel ID="Panel12" runat="server">
                <asp:Label ID="FaxNum" CssClass="inputLabel" runat="server">
                    <asp:Label ID="Label23" runat="server" Text="Fax" />
                    <asp:Label ID="Label24" CssClass="inputDes" runat="server" Text="Your fax number" />
                </asp:Label><asp:TextBox ID="txtPhoneNumFax" Columns="13" MaxLength="13" runat="server" CssClass="inputBox" />
                <asp:RegularExpressionValidator ID="revPhoneNumFax" CssClass="error_message_small" Display="Dynamic" runat="server"
                    ControlToValidate="txtPhoneNumFax" ErrorMessage="Enter valid format: (248)123-4567, 248-123-4567, 248 123 4567 or 248.123.4567"
                    ValidationExpression="(\([2-9]\d{2}|[2-9]\d{2})[\)\- .]\d{3}[\- .]\d{4}" />
            </asp:Panel>
            <br />
            <asp:Panel ID="Panel13" runat="server">
                <asp:Label ID="Label25" CssClass="inputLabel" style="margin-right:30px" runat="server" >
                    <asp:Label ID="lblRequired" CssClass="inputDes" runat="server" Text="* Required Field"/>
                </asp:Label><asp:Button ID="btnCreate" runat="server" Text="Create Account" OnClick="btnCreate_Click" UseSubmitBehavior="false"
                    OnClientClick="if (Page_ClientValidate() == true){ btnCreate.value = 'Processing...'; btnCreate.Enabled = false; __doPostBack('btnCreate','');}" />
            </asp:Panel>
            <uc1:outside_footer ID="footer" runat="server" />
        </div>
    </form>
</body>
</html>