﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ForgotPassword.aspx.cs" Inherits="SedonaWeb.ForgotPassword" %>
<%@ Register Src="/Customizable/outside_Header.ascx" TagName="outside_Header" TagPrefix="uc2" %>
<%@ Register Src="/Customizable/outside_footer.ascx" TagName="outside_footer" TagPrefix="uc1" %>


<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <%= SedonaWeb.SWSCore.WebSettings.PageHeadInclude %>
    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.3.2/jquery.min.js"></script>
    <link href="/css/global.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server"  autocomplete="off">
    <div id="formContainer">
        <uc2:outside_Header ID="outside" runat="server" /> 
        <asp:Label CssClass="pageTitle" runat="server" Text="Forgotten Password" />
        <asp:Label CssClass="pageDes" runat="server" Text="Enter the email address of your account to recover your password." />
        <asp:Panel ID="Panel1" runat="server">
            <asp:Label ID="EmailAddress" CssClass="inputLabel" runat="server">
                <asp:Label ID="Label2" runat="server" Text="Email Address" />
                <asp:Label runat="server" Text="Enter your email address" CssClass="inputDes"/>
            </asp:Label>
            <asp:TextBox ID="txtEmailAddress" runat="server" CssClass="inputBox" Columns="60" />  
            <asp:RequiredFieldValidator ID="rfvEmailAddress" runat="server" CssClass="error_message_small"
                ErrorMessage="Required Field" ControlToValidate="txtEmailAddress" Display="Dynamic" />
            <asp:RegularExpressionValidator ID="regEmail" CssClass="error_message_small" Display="Dynamic" runat="server"
                ControlToValidate="txtEmailAddress" ErrorMessage="You must enter a valid email address "
                ValidationExpression="\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*" />
        </asp:Panel>
        <asp:Panel ID="Panel2" runat="server">
            <asp:Button ID="btnSubmit" runat="server" Text="Submit" onclick="btnSubmit_Click" style="margin-left:190px"
                OnClientClick="if (Page_ClientValidate() == true) {this.value = 'Processing...'; this.disabled = true; __doPostBack('btnSubmit','');}"/>
        </asp:Panel>
        <p>                     
            <asp:Label ID="lblError" runat="server" CssClass="error_message_small"/>
            <asp:Label ID="lblSuccess" runat="server" CssClass="success_message"/> 
        </p>
        <uc1:outside_footer ID="footer" runat="server"/>
    </div>
    </form>
</body>
</html>